/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class ApiApp {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String appId;
    protected final String appName;
    protected final String publisher;
    protected final String publisherUrl;
    protected final Date linked;
    protected final boolean isAppFolder;

    public ApiApp(String appId, String appName, boolean isAppFolder, String publisher, String publisherUrl, Date linked) {
        if (appId == null) {
            throw new IllegalArgumentException("Required value for 'appId' is null");
        }
        this.appId = appId;
        if (appName == null) {
            throw new IllegalArgumentException("Required value for 'appName' is null");
        }
        this.appName = appName;
        this.publisher = publisher;
        this.publisherUrl = publisherUrl;
        this.linked = linked;
        this.isAppFolder = isAppFolder;
    }

    public ApiApp(String appId, String appName, boolean isAppFolder) {
        this(appId, appName, isAppFolder, null, null, null);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public String getPublisherUrl() {
        return this.publisherUrl;
    }

    public Date getLinked() {
        return this.linked;
    }

    public boolean getIsAppFolder() {
        return this.isAppFolder;
    }

    public static Builder newBuilder(String appId, String appName, boolean isAppFolder) {
        return new Builder(appId, appName, isAppFolder);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.appId, this.appName, this.publisher, this.publisherUrl, this.linked, this.isAppFolder});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            ApiApp other = (ApiApp)obj;
            return !(this.appId != other.appId && !this.appId.equals(other.appId) || this.appName != other.appName && !this.appName.equals(other.appName) || this.isAppFolder != other.isAppFolder || this.publisher != other.publisher && (this.publisher == null || !this.publisher.equals(other.publisher)) || this.publisherUrl != other.publisherUrl && (this.publisherUrl == null || !this.publisherUrl.equals(other.publisherUrl)) || this.linked != other.linked && (this.linked == null || !this.linked.equals(other.linked)));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<ApiApp> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(ApiApp.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(ApiApp.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<ApiApp> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public ApiApp deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String appId = null;
            String appName = null;
            Boolean isAppFolder = null;
            String publisher = null;
            String publisherUrl = null;
            Date linked = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("app_id".equals(_field)) {
                    appId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("app_name".equals(_field)) {
                    appName = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("is_app_folder".equals(_field)) {
                    isAppFolder = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                if ("publisher".equals(_field)) {
                    publisher = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("publisher_url".equals(_field)) {
                    publisherUrl = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("linked".equals(_field)) {
                    linked = _ctx.parseDate(Deserializer.getStringValue(_p));
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (appId == null) {
                throw new JsonParseException(_p, "Required field \"app_id\" is missing.");
            }
            if (appName == null) {
                throw new JsonParseException(_p, "Required field \"app_name\" is missing.");
            }
            if (isAppFolder == null) {
                throw new JsonParseException(_p, "Required field \"is_app_folder\" is missing.");
            }
            return new ApiApp(appId, appName, isAppFolder, publisher, publisherUrl, linked);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<ApiApp> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(ApiApp.class);
        }

        public Serializer(boolean unwrapping) {
            super(ApiApp.class, unwrapping);
        }

        @Override
        protected JsonSerializer<ApiApp> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(ApiApp value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("app_id", value.appId);
            g.writeObjectField("app_name", value.appName);
            g.writeObjectField("is_app_folder", value.isAppFolder);
            if (value.publisher != null) {
                g.writeObjectField("publisher", value.publisher);
            }
            if (value.publisherUrl != null) {
                g.writeObjectField("publisher_url", value.publisherUrl);
            }
            if (value.linked != null) {
                g.writeObjectField("linked", value.linked);
            }
        }
    }

    public static class Builder {
        protected final String appId;
        protected final String appName;
        protected final boolean isAppFolder;
        protected String publisher;
        protected String publisherUrl;
        protected Date linked;

        protected Builder(String appId, String appName, boolean isAppFolder) {
            if (appId == null) {
                throw new IllegalArgumentException("Required value for 'appId' is null");
            }
            this.appId = appId;
            if (appName == null) {
                throw new IllegalArgumentException("Required value for 'appName' is null");
            }
            this.appName = appName;
            this.isAppFolder = isAppFolder;
            this.publisher = null;
            this.publisherUrl = null;
            this.linked = null;
        }

        public Builder withPublisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder withPublisherUrl(String publisherUrl) {
            this.publisherUrl = publisherUrl;
            return this;
        }

        public Builder withLinked(Date linked) {
            this.linked = linked;
            return this;
        }

        public ApiApp build() {
            return new ApiApp(this.appId, this.appName, this.isAppFolder, this.publisher, this.publisherUrl, this.linked);
        }
    }
}

