/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.team.GroupMemberInfo;
import com.dropbox.core.v2.team.GroupSummary;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class GroupFullInfo
extends GroupSummary {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final List<GroupMemberInfo> members;
    protected final long created;

    public GroupFullInfo(String groupName, String groupId, long memberCount, List<GroupMemberInfo> members, long created, String groupExternalId) {
        super(groupName, groupId, memberCount, groupExternalId);
        if (members == null) {
            throw new IllegalArgumentException("Required value for 'members' is null");
        }
        for (GroupMemberInfo x : members) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'members' is null");
        }
        this.members = members;
        this.created = created;
    }

    public GroupFullInfo(String groupName, String groupId, long memberCount, List<GroupMemberInfo> members, long created) {
        this(groupName, groupId, memberCount, members, created, null);
    }

    public List<GroupMemberInfo> getMembers() {
        return this.members;
    }

    public long getCreated() {
        return this.created;
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.members, this.created});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            GroupFullInfo other = (GroupFullInfo)obj;
            return !(this.groupName != other.groupName && !this.groupName.equals(other.groupName) || this.groupId != other.groupId && !this.groupId.equals(other.groupId) || this.memberCount != other.memberCount || this.members != other.members && !this.members.equals(other.members) || this.created != other.created || this.groupExternalId != other.groupExternalId && (this.groupExternalId == null || !this.groupExternalId.equals(other.groupExternalId)));
        }
        return false;
    }

    @Override
    public String toString() {
        return this.serialize(false);
    }

    @Override
    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<GroupFullInfo> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(GroupFullInfo.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(GroupFullInfo.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<GroupFullInfo> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public GroupFullInfo deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String groupName = null;
            String groupId = null;
            Long memberCount = null;
            ArrayList<GroupMemberInfo> members = null;
            Long created = null;
            String groupExternalId = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("group_name".equals(_field)) {
                    groupName = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("group_id".equals(_field)) {
                    groupId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("member_count".equals(_field)) {
                    memberCount = _p.getLongValue();
                    Deserializer.assertUnsigned(_p, memberCount);
                    if (memberCount > Integer.MAX_VALUE) {
                        throw new JsonParseException(_p, "expecting a 32-bit unsigned integer, got: " + memberCount);
                    }
                    _p.nextToken();
                    continue;
                }
                if ("members".equals(_field)) {
                    Deserializer.expectArrayStart(_p);
                    members = new ArrayList<GroupMemberInfo>();
                    while (!Deserializer.isArrayEnd(_p)) {
                        GroupMemberInfo _x = null;
                        _x = _p.readValueAs(GroupMemberInfo.class);
                        _p.nextToken();
                        members.add(_x);
                    }
                    Deserializer.expectArrayEnd(_p);
                    _p.nextToken();
                    continue;
                }
                if ("created".equals(_field)) {
                    created = _p.getLongValue();
                    Deserializer.assertUnsigned(_p, created);
                    _p.nextToken();
                    continue;
                }
                if ("group_external_id".equals(_field)) {
                    groupExternalId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (groupName == null) {
                throw new JsonParseException(_p, "Required field \"group_name\" is missing.");
            }
            if (groupId == null) {
                throw new JsonParseException(_p, "Required field \"group_id\" is missing.");
            }
            if (memberCount == null) {
                throw new JsonParseException(_p, "Required field \"member_count\" is missing.");
            }
            if (members == null) {
                throw new JsonParseException(_p, "Required field \"members\" is missing.");
            }
            if (created == null) {
                throw new JsonParseException(_p, "Required field \"created\" is missing.");
            }
            return new GroupFullInfo(groupName, groupId, memberCount, members, created, groupExternalId);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<GroupFullInfo> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(GroupFullInfo.class);
        }

        public Serializer(boolean unwrapping) {
            super(GroupFullInfo.class, unwrapping);
        }

        @Override
        protected JsonSerializer<GroupFullInfo> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(GroupFullInfo value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("group_name", value.groupName);
            g.writeObjectField("group_id", value.groupId);
            g.writeObjectField("member_count", value.memberCount);
            g.writeObjectField("members", value.members);
            g.writeObjectField("created", value.created);
            if (value.groupExternalId != null) {
                g.writeObjectField("group_external_id", value.groupExternalId);
            }
        }
    }
}

