/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.team.GroupAccessType;
import com.dropbox.core.v2.team.MemberProfile;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class GroupMemberInfo {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final MemberProfile profile;
    protected final GroupAccessType accessType;

    public GroupMemberInfo(MemberProfile profile, GroupAccessType accessType) {
        if (profile == null) {
            throw new IllegalArgumentException("Required value for 'profile' is null");
        }
        this.profile = profile;
        if (accessType == null) {
            throw new IllegalArgumentException("Required value for 'accessType' is null");
        }
        this.accessType = accessType;
    }

    public MemberProfile getProfile() {
        return this.profile;
    }

    public GroupAccessType getAccessType() {
        return this.accessType;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.profile, this.accessType});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            GroupMemberInfo other = (GroupMemberInfo)obj;
            return !(this.profile != other.profile && !this.profile.equals(other.profile) || this.accessType != other.accessType && !this.accessType.equals((Object)other.accessType));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<GroupMemberInfo> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(GroupMemberInfo.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(GroupMemberInfo.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<GroupMemberInfo> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public GroupMemberInfo deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            MemberProfile profile = null;
            GroupAccessType accessType = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("profile".equals(_field)) {
                    profile = _p.readValueAs(MemberProfile.class);
                    _p.nextToken();
                    continue;
                }
                if ("access_type".equals(_field)) {
                    accessType = _p.readValueAs(GroupAccessType.class);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (profile == null) {
                throw new JsonParseException(_p, "Required field \"profile\" is missing.");
            }
            if (accessType == null) {
                throw new JsonParseException(_p, "Required field \"access_type\" is missing.");
            }
            return new GroupMemberInfo(profile, accessType);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<GroupMemberInfo> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(GroupMemberInfo.class);
        }

        public Serializer(boolean unwrapping) {
            super(GroupMemberInfo.class, unwrapping);
        }

        @Override
        protected JsonSerializer<GroupMemberInfo> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(GroupMemberInfo value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("profile", value.profile);
            g.writeObjectField("access_type", (Object)value.accessType);
        }
    }
}

