/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.team.GroupSelector;
import com.dropbox.core.v2.team.MemberAccess;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
class GroupMembersAddArg {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final GroupSelector group;
    protected final List<MemberAccess> members;

    public GroupMembersAddArg(GroupSelector group, List<MemberAccess> members) {
        if (group == null) {
            throw new IllegalArgumentException("Required value for 'group' is null");
        }
        this.group = group;
        if (members == null) {
            throw new IllegalArgumentException("Required value for 'members' is null");
        }
        for (MemberAccess x : members) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'members' is null");
        }
        this.members = members;
    }

    public GroupSelector getGroup() {
        return this.group;
    }

    public List<MemberAccess> getMembers() {
        return this.members;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.group, this.members});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            GroupMembersAddArg other = (GroupMembersAddArg)obj;
            return !(this.group != other.group && !this.group.equals(other.group) || this.members != other.members && !this.members.equals(other.members));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<GroupMembersAddArg> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(GroupMembersAddArg.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(GroupMembersAddArg.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<GroupMembersAddArg> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public GroupMembersAddArg deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            GroupSelector group = null;
            ArrayList<MemberAccess> members = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("group".equals(_field)) {
                    group = _p.readValueAs(GroupSelector.class);
                    _p.nextToken();
                    continue;
                }
                if ("members".equals(_field)) {
                    Deserializer.expectArrayStart(_p);
                    members = new ArrayList<MemberAccess>();
                    while (!Deserializer.isArrayEnd(_p)) {
                        MemberAccess _x = null;
                        _x = _p.readValueAs(MemberAccess.class);
                        _p.nextToken();
                        members.add(_x);
                    }
                    Deserializer.expectArrayEnd(_p);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (group == null) {
                throw new JsonParseException(_p, "Required field \"group\" is missing.");
            }
            if (members == null) {
                throw new JsonParseException(_p, "Required field \"members\" is missing.");
            }
            return new GroupMembersAddArg(group, members);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<GroupMembersAddArg> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(GroupMembersAddArg.class);
        }

        public Serializer(boolean unwrapping) {
            super(GroupMembersAddArg.class, unwrapping);
        }

        @Override
        protected JsonSerializer<GroupMembersAddArg> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(GroupMembersAddArg value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("group", value.group);
            g.writeObjectField("members", value.members);
        }
    }
}

