/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.UnionJsonDeserializer;
import com.dropbox.core.json.UnionJsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public final class GroupSelector {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    private final Tag tag;
    private final String groupIdValue;
    private final String groupExternalIdValue;

    private GroupSelector(Tag tag, String groupIdValue, String groupExternalIdValue) {
        this.tag = tag;
        this.groupIdValue = groupIdValue;
        this.groupExternalIdValue = groupExternalIdValue;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isGroupId() {
        return this.tag == Tag.GROUP_ID;
    }

    public static GroupSelector groupId(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new GroupSelector(Tag.GROUP_ID, value, null);
    }

    public String getGroupIdValue() {
        if (this.tag != Tag.GROUP_ID) {
            throw new IllegalStateException("Invalid tag: required Tag.GROUP_ID, but was Tag." + this.tag.name());
        }
        return this.groupIdValue;
    }

    public boolean isGroupExternalId() {
        return this.tag == Tag.GROUP_EXTERNAL_ID;
    }

    public static GroupSelector groupExternalId(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new GroupSelector(Tag.GROUP_EXTERNAL_ID, null, value);
    }

    public String getGroupExternalIdValue() {
        if (this.tag != Tag.GROUP_EXTERNAL_ID) {
            throw new IllegalStateException("Invalid tag: required Tag.GROUP_EXTERNAL_ID, but was Tag." + this.tag.name());
        }
        return this.groupExternalIdValue;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.tag, this.groupIdValue, this.groupExternalIdValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof GroupSelector) {
            GroupSelector other = (GroupSelector)obj;
            if (this.tag != other.tag) {
                return false;
            }
            switch (this.tag) {
                case GROUP_ID: {
                    return this.groupIdValue == other.groupIdValue || this.groupIdValue.equals(other.groupIdValue);
                }
                case GROUP_EXTERNAL_ID: {
                    return this.groupExternalIdValue == other.groupExternalIdValue || this.groupExternalIdValue.equals(other.groupExternalIdValue);
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends UnionJsonDeserializer<GroupSelector, Tag> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(GroupSelector.class, Deserializer.getTagMapping(), null, new Class[0]);
        }

        @Override
        public GroupSelector deserialize(Tag _tag, JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            switch (_tag) {
                case GROUP_ID: {
                    String value = null;
                    Deserializer.expectField(_p, "group_id");
                    value = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    return GroupSelector.groupId(value);
                }
                case GROUP_EXTERNAL_ID: {
                    String value = null;
                    Deserializer.expectField(_p, "group_external_id");
                    value = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    return GroupSelector.groupExternalId(value);
                }
            }
            throw new IllegalStateException("Unparsed tag: \"" + (Object)((Object)_tag) + "\"");
        }

        private static Map<String, Tag> getTagMapping() {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            values.put("group_id", Tag.GROUP_ID);
            values.put("group_external_id", Tag.GROUP_EXTERNAL_ID);
            return Collections.unmodifiableMap(values);
        }
    }

    static final class Serializer
    extends UnionJsonSerializer<GroupSelector> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(GroupSelector.class, new Class[0]);
        }

        @Override
        public void serialize(GroupSelector value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            switch (value.tag) {
                case GROUP_ID: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "group_id");
                    g.writeObjectField("group_id", value.groupIdValue);
                    g.writeEndObject();
                    break;
                }
                case GROUP_EXTERNAL_ID: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "group_external_id");
                    g.writeObjectField("group_external_id", value.groupExternalIdValue);
                    g.writeEndObject();
                }
            }
        }
    }

    public static enum Tag {
        GROUP_ID,
        GROUP_EXTERNAL_ID;

    }
}

