/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
class GroupsListArg {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final long limit;

    public GroupsListArg(long limit) {
        if (limit < 1L) {
            throw new IllegalArgumentException("Number 'limit' is smaller than 1L");
        }
        if (limit > 1000L) {
            throw new IllegalArgumentException("Number 'limit' is larger than 1000L");
        }
        this.limit = limit;
    }

    public GroupsListArg() {
        this(1000L);
    }

    public long getLimit() {
        return this.limit;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.limit});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            GroupsListArg other = (GroupsListArg)obj;
            return this.limit == other.limit;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<GroupsListArg> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(GroupsListArg.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(GroupsListArg.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<GroupsListArg> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public GroupsListArg deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            Long limit = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("limit".equals(_field)) {
                    limit = _p.getLongValue();
                    Deserializer.assertUnsigned(_p, limit);
                    if (limit > Integer.MAX_VALUE) {
                        throw new JsonParseException(_p, "expecting a 32-bit unsigned integer, got: " + limit);
                    }
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            return new GroupsListArg(limit);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<GroupsListArg> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(GroupsListArg.class);
        }

        public Serializer(boolean unwrapping) {
            super(GroupsListArg.class, unwrapping);
        }

        @Override
        protected JsonSerializer<GroupsListArg> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(GroupsListArg value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("limit", value.limit);
        }
    }
}

