/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
class ListMemberDevicesArg {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String teamMemberId;
    protected final boolean includeWebSessions;
    protected final boolean includeDesktopClients;
    protected final boolean includeMobileClients;

    public ListMemberDevicesArg(String teamMemberId, boolean includeWebSessions, boolean includeDesktopClients, boolean includeMobileClients) {
        if (teamMemberId == null) {
            throw new IllegalArgumentException("Required value for 'teamMemberId' is null");
        }
        this.teamMemberId = teamMemberId;
        this.includeWebSessions = includeWebSessions;
        this.includeDesktopClients = includeDesktopClients;
        this.includeMobileClients = includeMobileClients;
    }

    public ListMemberDevicesArg(String teamMemberId) {
        this(teamMemberId, true, true, true);
    }

    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    public boolean getIncludeWebSessions() {
        return this.includeWebSessions;
    }

    public boolean getIncludeDesktopClients() {
        return this.includeDesktopClients;
    }

    public boolean getIncludeMobileClients() {
        return this.includeMobileClients;
    }

    public static Builder newBuilder(String teamMemberId) {
        return new Builder(teamMemberId);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.teamMemberId, this.includeWebSessions, this.includeDesktopClients, this.includeMobileClients});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            ListMemberDevicesArg other = (ListMemberDevicesArg)obj;
            return (this.teamMemberId == other.teamMemberId || this.teamMemberId.equals(other.teamMemberId)) && this.includeWebSessions == other.includeWebSessions && this.includeDesktopClients == other.includeDesktopClients && this.includeMobileClients == other.includeMobileClients;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<ListMemberDevicesArg> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(ListMemberDevicesArg.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(ListMemberDevicesArg.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<ListMemberDevicesArg> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public ListMemberDevicesArg deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String teamMemberId = null;
            Boolean includeWebSessions = null;
            Boolean includeDesktopClients = null;
            Boolean includeMobileClients = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("team_member_id".equals(_field)) {
                    teamMemberId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("include_web_sessions".equals(_field)) {
                    includeWebSessions = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                if ("include_desktop_clients".equals(_field)) {
                    includeDesktopClients = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                if ("include_mobile_clients".equals(_field)) {
                    includeMobileClients = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (teamMemberId == null) {
                throw new JsonParseException(_p, "Required field \"team_member_id\" is missing.");
            }
            return new ListMemberDevicesArg(teamMemberId, includeWebSessions, includeDesktopClients, includeMobileClients);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<ListMemberDevicesArg> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(ListMemberDevicesArg.class);
        }

        public Serializer(boolean unwrapping) {
            super(ListMemberDevicesArg.class, unwrapping);
        }

        @Override
        protected JsonSerializer<ListMemberDevicesArg> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(ListMemberDevicesArg value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("team_member_id", value.teamMemberId);
            g.writeObjectField("include_web_sessions", value.includeWebSessions);
            g.writeObjectField("include_desktop_clients", value.includeDesktopClients);
            g.writeObjectField("include_mobile_clients", value.includeMobileClients);
        }
    }

    public static class Builder {
        protected final String teamMemberId;
        protected boolean includeWebSessions;
        protected boolean includeDesktopClients;
        protected boolean includeMobileClients;

        protected Builder(String teamMemberId) {
            if (teamMemberId == null) {
                throw new IllegalArgumentException("Required value for 'teamMemberId' is null");
            }
            this.teamMemberId = teamMemberId;
            this.includeWebSessions = true;
            this.includeDesktopClients = true;
            this.includeMobileClients = true;
        }

        public Builder withIncludeWebSessions(Boolean includeWebSessions) {
            this.includeWebSessions = includeWebSessions != null ? includeWebSessions : true;
            return this;
        }

        public Builder withIncludeDesktopClients(Boolean includeDesktopClients) {
            this.includeDesktopClients = includeDesktopClients != null ? includeDesktopClients : true;
            return this;
        }

        public Builder withIncludeMobileClients(Boolean includeMobileClients) {
            this.includeMobileClients = includeMobileClients != null ? includeMobileClients : true;
            return this;
        }

        public ListMemberDevicesArg build() {
            return new ListMemberDevicesArg(this.teamMemberId, this.includeWebSessions, this.includeDesktopClients, this.includeMobileClients);
        }
    }
}

