/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.team.MemberDevices;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class ListTeamDevicesResult {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final List<MemberDevices> devices;
    protected final boolean hasMore;
    protected final String cursor;

    public ListTeamDevicesResult(List<MemberDevices> devices, boolean hasMore, String cursor) {
        if (devices == null) {
            throw new IllegalArgumentException("Required value for 'devices' is null");
        }
        for (MemberDevices x : devices) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'devices' is null");
        }
        this.devices = devices;
        this.hasMore = hasMore;
        this.cursor = cursor;
    }

    public ListTeamDevicesResult(List<MemberDevices> devices, boolean hasMore) {
        this(devices, hasMore, null);
    }

    public List<MemberDevices> getDevices() {
        return this.devices;
    }

    public boolean getHasMore() {
        return this.hasMore;
    }

    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.devices, this.hasMore, this.cursor});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            ListTeamDevicesResult other = (ListTeamDevicesResult)obj;
            return (this.devices == other.devices || this.devices.equals(other.devices)) && this.hasMore == other.hasMore && (this.cursor == other.cursor || this.cursor != null && this.cursor.equals(other.cursor));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<ListTeamDevicesResult> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(ListTeamDevicesResult.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(ListTeamDevicesResult.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<ListTeamDevicesResult> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public ListTeamDevicesResult deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            ArrayList<MemberDevices> devices = null;
            Boolean hasMore = null;
            String cursor = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("devices".equals(_field)) {
                    Deserializer.expectArrayStart(_p);
                    devices = new ArrayList<MemberDevices>();
                    while (!Deserializer.isArrayEnd(_p)) {
                        MemberDevices _x = null;
                        _x = _p.readValueAs(MemberDevices.class);
                        _p.nextToken();
                        devices.add(_x);
                    }
                    Deserializer.expectArrayEnd(_p);
                    _p.nextToken();
                    continue;
                }
                if ("has_more".equals(_field)) {
                    hasMore = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                if ("cursor".equals(_field)) {
                    cursor = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (devices == null) {
                throw new JsonParseException(_p, "Required field \"devices\" is missing.");
            }
            if (hasMore == null) {
                throw new JsonParseException(_p, "Required field \"has_more\" is missing.");
            }
            return new ListTeamDevicesResult(devices, hasMore, cursor);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<ListTeamDevicesResult> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(ListTeamDevicesResult.class);
        }

        public Serializer(boolean unwrapping) {
            super(ListTeamDevicesResult.class, unwrapping);
        }

        @Override
        protected JsonSerializer<ListTeamDevicesResult> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(ListTeamDevicesResult value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("devices", value.devices);
            g.writeObjectField("has_more", value.hasMore);
            if (value.cursor != null) {
                g.writeObjectField("cursor", value.cursor);
            }
        }
    }
}

