/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.team.ActiveWebSession;
import com.dropbox.core.v2.team.DesktopClientSession;
import com.dropbox.core.v2.team.DeviceSession;
import com.dropbox.core.v2.team.MobileClientSession;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class MemberDevices {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String teamMemberId;
    protected final List<ActiveWebSession> webSessions;
    protected final List<DesktopClientSession> desktopClients;
    protected final List<MobileClientSession> mobileClients;

    public MemberDevices(String teamMemberId, List<ActiveWebSession> webSessions, List<DesktopClientSession> desktopClients, List<MobileClientSession> mobileClients) {
        if (teamMemberId == null) {
            throw new IllegalArgumentException("Required value for 'teamMemberId' is null");
        }
        this.teamMemberId = teamMemberId;
        if (webSessions != null) {
            for (ActiveWebSession activeWebSession : webSessions) {
                if (activeWebSession != null) continue;
                throw new IllegalArgumentException("An item in list 'webSessions' is null");
            }
        }
        this.webSessions = webSessions;
        if (desktopClients != null) {
            for (DesktopClientSession desktopClientSession : desktopClients) {
                if (desktopClientSession != null) continue;
                throw new IllegalArgumentException("An item in list 'desktopClients' is null");
            }
        }
        this.desktopClients = desktopClients;
        if (mobileClients != null) {
            for (MobileClientSession mobileClientSession : mobileClients) {
                if (mobileClientSession != null) continue;
                throw new IllegalArgumentException("An item in list 'mobileClients' is null");
            }
        }
        this.mobileClients = mobileClients;
    }

    public MemberDevices(String teamMemberId) {
        this(teamMemberId, null, null, null);
    }

    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    public List<ActiveWebSession> getWebSessions() {
        return this.webSessions;
    }

    public List<DesktopClientSession> getDesktopClients() {
        return this.desktopClients;
    }

    public List<MobileClientSession> getMobileClients() {
        return this.mobileClients;
    }

    public static Builder newBuilder(String teamMemberId) {
        return new Builder(teamMemberId);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.teamMemberId, this.webSessions, this.desktopClients, this.mobileClients});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            MemberDevices other = (MemberDevices)obj;
            return (this.teamMemberId == other.teamMemberId || this.teamMemberId.equals(other.teamMemberId)) && (this.webSessions == other.webSessions || this.webSessions != null && this.webSessions.equals(other.webSessions)) && (this.desktopClients == other.desktopClients || this.desktopClients != null && this.desktopClients.equals(other.desktopClients)) && (this.mobileClients == other.mobileClients || this.mobileClients != null && this.mobileClients.equals(other.mobileClients));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<MemberDevices> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(MemberDevices.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(MemberDevices.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<MemberDevices> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public MemberDevices deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String teamMemberId = null;
            ArrayList<ActiveWebSession> webSessions = null;
            ArrayList<ActiveWebSession> desktopClients = null;
            ArrayList<ActiveWebSession> mobileClients = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                DeviceSession _x;
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("team_member_id".equals(_field)) {
                    teamMemberId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("web_sessions".equals(_field)) {
                    Deserializer.expectArrayStart(_p);
                    webSessions = new ArrayList<ActiveWebSession>();
                    while (!Deserializer.isArrayEnd(_p)) {
                        _x = null;
                        _x = _p.readValueAs(ActiveWebSession.class);
                        _p.nextToken();
                        webSessions.add((ActiveWebSession)_x);
                    }
                    Deserializer.expectArrayEnd(_p);
                    _p.nextToken();
                    continue;
                }
                if ("desktop_clients".equals(_field)) {
                    Deserializer.expectArrayStart(_p);
                    desktopClients = new ArrayList<ActiveWebSession>();
                    while (!Deserializer.isArrayEnd(_p)) {
                        _x = null;
                        _x = _p.readValueAs(DesktopClientSession.class);
                        _p.nextToken();
                        desktopClients.add((ActiveWebSession)_x);
                    }
                    Deserializer.expectArrayEnd(_p);
                    _p.nextToken();
                    continue;
                }
                if ("mobile_clients".equals(_field)) {
                    Deserializer.expectArrayStart(_p);
                    mobileClients = new ArrayList<ActiveWebSession>();
                    while (!Deserializer.isArrayEnd(_p)) {
                        _x = null;
                        _x = _p.readValueAs(MobileClientSession.class);
                        _p.nextToken();
                        mobileClients.add((ActiveWebSession)_x);
                    }
                    Deserializer.expectArrayEnd(_p);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (teamMemberId == null) {
                throw new JsonParseException(_p, "Required field \"team_member_id\" is missing.");
            }
            return new MemberDevices(teamMemberId, webSessions, desktopClients, mobileClients);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<MemberDevices> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(MemberDevices.class);
        }

        public Serializer(boolean unwrapping) {
            super(MemberDevices.class, unwrapping);
        }

        @Override
        protected JsonSerializer<MemberDevices> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(MemberDevices value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("team_member_id", value.teamMemberId);
            if (value.webSessions != null) {
                g.writeObjectField("web_sessions", value.webSessions);
            }
            if (value.desktopClients != null) {
                g.writeObjectField("desktop_clients", value.desktopClients);
            }
            if (value.mobileClients != null) {
                g.writeObjectField("mobile_clients", value.mobileClients);
            }
        }
    }

    public static class Builder {
        protected final String teamMemberId;
        protected List<ActiveWebSession> webSessions;
        protected List<DesktopClientSession> desktopClients;
        protected List<MobileClientSession> mobileClients;

        protected Builder(String teamMemberId) {
            if (teamMemberId == null) {
                throw new IllegalArgumentException("Required value for 'teamMemberId' is null");
            }
            this.teamMemberId = teamMemberId;
            this.webSessions = null;
            this.desktopClients = null;
            this.mobileClients = null;
        }

        public Builder withWebSessions(List<ActiveWebSession> webSessions) {
            if (webSessions != null) {
                for (ActiveWebSession x : webSessions) {
                    if (x != null) continue;
                    throw new IllegalArgumentException("An item in list 'webSessions' is null");
                }
            }
            this.webSessions = webSessions;
            return this;
        }

        public Builder withDesktopClients(List<DesktopClientSession> desktopClients) {
            if (desktopClients != null) {
                for (DesktopClientSession x : desktopClients) {
                    if (x != null) continue;
                    throw new IllegalArgumentException("An item in list 'desktopClients' is null");
                }
            }
            this.desktopClients = desktopClients;
            return this;
        }

        public Builder withMobileClients(List<MobileClientSession> mobileClients) {
            if (mobileClients != null) {
                for (MobileClientSession x : mobileClients) {
                    if (x != null) continue;
                    throw new IllegalArgumentException("An item in list 'mobileClients' is null");
                }
            }
            this.mobileClients = mobileClients;
            return this;
        }

        public MemberDevices build() {
            return new MemberDevices(this.teamMemberId, this.webSessions, this.desktopClients, this.mobileClients);
        }
    }
}

