/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.UnionJsonDeserializer;
import com.dropbox.core.json.UnionJsonSerializer;
import com.dropbox.core.v2.team.TeamMemberInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public final class MembersGetInfoItem {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    private final Tag tag;
    private final String idNotFoundValue;
    private final TeamMemberInfo memberInfoValue;

    private MembersGetInfoItem(Tag tag, String idNotFoundValue, TeamMemberInfo memberInfoValue) {
        this.tag = tag;
        this.idNotFoundValue = idNotFoundValue;
        this.memberInfoValue = memberInfoValue;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isIdNotFound() {
        return this.tag == Tag.ID_NOT_FOUND;
    }

    public static MembersGetInfoItem idNotFound(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new MembersGetInfoItem(Tag.ID_NOT_FOUND, value, null);
    }

    public String getIdNotFoundValue() {
        if (this.tag != Tag.ID_NOT_FOUND) {
            throw new IllegalStateException("Invalid tag: required Tag.ID_NOT_FOUND, but was Tag." + this.tag.name());
        }
        return this.idNotFoundValue;
    }

    public boolean isMemberInfo() {
        return this.tag == Tag.MEMBER_INFO;
    }

    public static MembersGetInfoItem memberInfo(TeamMemberInfo value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new MembersGetInfoItem(Tag.MEMBER_INFO, null, value);
    }

    public TeamMemberInfo getMemberInfoValue() {
        if (this.tag != Tag.MEMBER_INFO) {
            throw new IllegalStateException("Invalid tag: required Tag.MEMBER_INFO, but was Tag." + this.tag.name());
        }
        return this.memberInfoValue;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.tag, this.idNotFoundValue, this.memberInfoValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MembersGetInfoItem) {
            MembersGetInfoItem other = (MembersGetInfoItem)obj;
            if (this.tag != other.tag) {
                return false;
            }
            switch (this.tag) {
                case ID_NOT_FOUND: {
                    return this.idNotFoundValue == other.idNotFoundValue || this.idNotFoundValue.equals(other.idNotFoundValue);
                }
                case MEMBER_INFO: {
                    return this.memberInfoValue == other.memberInfoValue || this.memberInfoValue.equals(other.memberInfoValue);
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends UnionJsonDeserializer<MembersGetInfoItem, Tag> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(MembersGetInfoItem.class, Deserializer.getTagMapping(), null, TeamMemberInfo.class);
        }

        @Override
        public MembersGetInfoItem deserialize(Tag _tag, JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            switch (_tag) {
                case ID_NOT_FOUND: {
                    String value = null;
                    Deserializer.expectField(_p, "id_not_found");
                    value = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    return MembersGetInfoItem.idNotFound(value);
                }
                case MEMBER_INFO: {
                    TeamMemberInfo value = null;
                    value = this.readCollapsedStructValue(TeamMemberInfo.class, _p, _ctx);
                    return MembersGetInfoItem.memberInfo(value);
                }
            }
            throw new IllegalStateException("Unparsed tag: \"" + (Object)((Object)_tag) + "\"");
        }

        private static Map<String, Tag> getTagMapping() {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            values.put("id_not_found", Tag.ID_NOT_FOUND);
            values.put("member_info", Tag.MEMBER_INFO);
            return Collections.unmodifiableMap(values);
        }
    }

    static final class Serializer
    extends UnionJsonSerializer<MembersGetInfoItem> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(MembersGetInfoItem.class, TeamMemberInfo.class);
        }

        @Override
        public void serialize(MembersGetInfoItem value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            switch (value.tag) {
                case ID_NOT_FOUND: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "id_not_found");
                    g.writeObjectField("id_not_found", value.idNotFoundValue);
                    g.writeEndObject();
                    break;
                }
                case MEMBER_INFO: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "member_info");
                    this.getUnwrappingSerializer(TeamMemberInfo.class).serialize(value.memberInfoValue, g, provider);
                    g.writeEndObject();
                }
            }
        }
    }

    public static enum Tag {
        ID_NOT_FOUND,
        MEMBER_INFO;

    }
}

