/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.team.DeviceSessionArg;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class RevokeDesktopClientArg
extends DeviceSessionArg {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final boolean deleteOnUnlink;

    public RevokeDesktopClientArg(String sessionId, String teamMemberId, boolean deleteOnUnlink) {
        super(sessionId, teamMemberId);
        this.deleteOnUnlink = deleteOnUnlink;
    }

    public RevokeDesktopClientArg(String sessionId, String teamMemberId) {
        this(sessionId, teamMemberId, false);
    }

    public boolean getDeleteOnUnlink() {
        return this.deleteOnUnlink;
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.deleteOnUnlink});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            RevokeDesktopClientArg other = (RevokeDesktopClientArg)obj;
            return !(this.sessionId != other.sessionId && !this.sessionId.equals(other.sessionId) || this.teamMemberId != other.teamMemberId && !this.teamMemberId.equals(other.teamMemberId) || this.deleteOnUnlink != other.deleteOnUnlink);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.serialize(false);
    }

    @Override
    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<RevokeDesktopClientArg> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(RevokeDesktopClientArg.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(RevokeDesktopClientArg.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<RevokeDesktopClientArg> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public RevokeDesktopClientArg deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String sessionId = null;
            String teamMemberId = null;
            Boolean deleteOnUnlink = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("session_id".equals(_field)) {
                    sessionId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("team_member_id".equals(_field)) {
                    teamMemberId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("delete_on_unlink".equals(_field)) {
                    deleteOnUnlink = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (sessionId == null) {
                throw new JsonParseException(_p, "Required field \"session_id\" is missing.");
            }
            if (teamMemberId == null) {
                throw new JsonParseException(_p, "Required field \"team_member_id\" is missing.");
            }
            return new RevokeDesktopClientArg(sessionId, teamMemberId, deleteOnUnlink);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<RevokeDesktopClientArg> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(RevokeDesktopClientArg.class);
        }

        public Serializer(boolean unwrapping) {
            super(RevokeDesktopClientArg.class, unwrapping);
        }

        @Override
        protected JsonSerializer<RevokeDesktopClientArg> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(RevokeDesktopClientArg value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("session_id", value.sessionId);
            g.writeObjectField("team_member_id", value.teamMemberId);
            g.writeObjectField("delete_on_unlink", value.deleteOnUnlink);
        }
    }
}

