/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.team.AdminTier;
import com.dropbox.core.v2.team.TeamMemberProfile;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class TeamMemberInfo {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final TeamMemberProfile profile;
    protected final AdminTier role;

    public TeamMemberInfo(TeamMemberProfile profile, AdminTier role) {
        if (profile == null) {
            throw new IllegalArgumentException("Required value for 'profile' is null");
        }
        this.profile = profile;
        if (role == null) {
            throw new IllegalArgumentException("Required value for 'role' is null");
        }
        this.role = role;
    }

    public TeamMemberProfile getProfile() {
        return this.profile;
    }

    public AdminTier getRole() {
        return this.role;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.profile, this.role});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            TeamMemberInfo other = (TeamMemberInfo)obj;
            return !(this.profile != other.profile && !this.profile.equals(other.profile) || this.role != other.role && !this.role.equals((Object)other.role));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<TeamMemberInfo> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(TeamMemberInfo.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(TeamMemberInfo.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<TeamMemberInfo> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public TeamMemberInfo deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            TeamMemberProfile profile = null;
            AdminTier role = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("profile".equals(_field)) {
                    profile = _p.readValueAs(TeamMemberProfile.class);
                    _p.nextToken();
                    continue;
                }
                if ("role".equals(_field)) {
                    role = _p.readValueAs(AdminTier.class);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (profile == null) {
                throw new JsonParseException(_p, "Required field \"profile\" is missing.");
            }
            if (role == null) {
                throw new JsonParseException(_p, "Required field \"role\" is missing.");
            }
            return new TeamMemberInfo(profile, role);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<TeamMemberInfo> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(TeamMemberInfo.class);
        }

        public Serializer(boolean unwrapping) {
            super(TeamMemberInfo.class, unwrapping);
        }

        @Override
        protected JsonSerializer<TeamMemberInfo> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(TeamMemberInfo value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("profile", value.profile);
            g.writeObjectField("role", (Object)value.role);
        }
    }
}

