/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.UnionJsonDeserializer;
import com.dropbox.core.json.UnionJsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public final class UserSelectorArg {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    private final Tag tag;
    private final String teamMemberIdValue;
    private final String externalIdValue;
    private final String emailValue;

    private UserSelectorArg(Tag tag, String teamMemberIdValue, String externalIdValue, String emailValue) {
        this.tag = tag;
        this.teamMemberIdValue = teamMemberIdValue;
        this.externalIdValue = externalIdValue;
        this.emailValue = emailValue;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isTeamMemberId() {
        return this.tag == Tag.TEAM_MEMBER_ID;
    }

    public static UserSelectorArg teamMemberId(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new UserSelectorArg(Tag.TEAM_MEMBER_ID, value, null, null);
    }

    public String getTeamMemberIdValue() {
        if (this.tag != Tag.TEAM_MEMBER_ID) {
            throw new IllegalStateException("Invalid tag: required Tag.TEAM_MEMBER_ID, but was Tag." + this.tag.name());
        }
        return this.teamMemberIdValue;
    }

    public boolean isExternalId() {
        return this.tag == Tag.EXTERNAL_ID;
    }

    public static UserSelectorArg externalId(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new UserSelectorArg(Tag.EXTERNAL_ID, null, value, null);
    }

    public String getExternalIdValue() {
        if (this.tag != Tag.EXTERNAL_ID) {
            throw new IllegalStateException("Invalid tag: required Tag.EXTERNAL_ID, but was Tag." + this.tag.name());
        }
        return this.externalIdValue;
    }

    public boolean isEmail() {
        return this.tag == Tag.EMAIL;
    }

    public static UserSelectorArg email(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new UserSelectorArg(Tag.EMAIL, null, null, value);
    }

    public String getEmailValue() {
        if (this.tag != Tag.EMAIL) {
            throw new IllegalStateException("Invalid tag: required Tag.EMAIL, but was Tag." + this.tag.name());
        }
        return this.emailValue;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.tag, this.teamMemberIdValue, this.externalIdValue, this.emailValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof UserSelectorArg) {
            UserSelectorArg other = (UserSelectorArg)obj;
            if (this.tag != other.tag) {
                return false;
            }
            switch (this.tag) {
                case TEAM_MEMBER_ID: {
                    return this.teamMemberIdValue == other.teamMemberIdValue || this.teamMemberIdValue.equals(other.teamMemberIdValue);
                }
                case EXTERNAL_ID: {
                    return this.externalIdValue == other.externalIdValue || this.externalIdValue.equals(other.externalIdValue);
                }
                case EMAIL: {
                    return this.emailValue == other.emailValue || this.emailValue.equals(other.emailValue);
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends UnionJsonDeserializer<UserSelectorArg, Tag> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(UserSelectorArg.class, Deserializer.getTagMapping(), null, new Class[0]);
        }

        @Override
        public UserSelectorArg deserialize(Tag _tag, JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            switch (_tag) {
                case TEAM_MEMBER_ID: {
                    String value = null;
                    Deserializer.expectField(_p, "team_member_id");
                    value = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    return UserSelectorArg.teamMemberId(value);
                }
                case EXTERNAL_ID: {
                    String value = null;
                    Deserializer.expectField(_p, "external_id");
                    value = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    return UserSelectorArg.externalId(value);
                }
                case EMAIL: {
                    String value = null;
                    Deserializer.expectField(_p, "email");
                    value = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    return UserSelectorArg.email(value);
                }
            }
            throw new IllegalStateException("Unparsed tag: \"" + (Object)((Object)_tag) + "\"");
        }

        private static Map<String, Tag> getTagMapping() {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            values.put("team_member_id", Tag.TEAM_MEMBER_ID);
            values.put("external_id", Tag.EXTERNAL_ID);
            values.put("email", Tag.EMAIL);
            return Collections.unmodifiableMap(values);
        }
    }

    static final class Serializer
    extends UnionJsonSerializer<UserSelectorArg> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(UserSelectorArg.class, new Class[0]);
        }

        @Override
        public void serialize(UserSelectorArg value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            switch (value.tag) {
                case TEAM_MEMBER_ID: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "team_member_id");
                    g.writeObjectField("team_member_id", value.teamMemberIdValue);
                    g.writeEndObject();
                    break;
                }
                case EXTERNAL_ID: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "external_id");
                    g.writeObjectField("external_id", value.externalIdValue);
                    g.writeEndObject();
                    break;
                }
                case EMAIL: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "email");
                    g.writeObjectField("email", value.emailValue);
                    g.writeEndObject();
                }
            }
        }
    }

    public static enum Tag {
        TEAM_MEMBER_ID,
        EXTERNAL_ID,
        EMAIL;

    }
}

