/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.UnionJsonDeserializer;
import com.dropbox.core.json.UnionJsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public final class UsersSelectorArg {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    private final Tag tag;
    private final List<String> teamMemberIdsValue;
    private final List<String> externalIdsValue;
    private final List<String> emailsValue;

    private UsersSelectorArg(Tag tag, List<String> teamMemberIdsValue, List<String> externalIdsValue, List<String> emailsValue) {
        this.tag = tag;
        this.teamMemberIdsValue = teamMemberIdsValue;
        this.externalIdsValue = externalIdsValue;
        this.emailsValue = emailsValue;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isTeamMemberIds() {
        return this.tag == Tag.TEAM_MEMBER_IDS;
    }

    public static UsersSelectorArg teamMemberIds(List<String> value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        for (String x : value) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list is null");
        }
        return new UsersSelectorArg(Tag.TEAM_MEMBER_IDS, value, null, null);
    }

    public List<String> getTeamMemberIdsValue() {
        if (this.tag != Tag.TEAM_MEMBER_IDS) {
            throw new IllegalStateException("Invalid tag: required Tag.TEAM_MEMBER_IDS, but was Tag." + this.tag.name());
        }
        return this.teamMemberIdsValue;
    }

    public boolean isExternalIds() {
        return this.tag == Tag.EXTERNAL_IDS;
    }

    public static UsersSelectorArg externalIds(List<String> value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        for (String x : value) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list is null");
        }
        return new UsersSelectorArg(Tag.EXTERNAL_IDS, null, value, null);
    }

    public List<String> getExternalIdsValue() {
        if (this.tag != Tag.EXTERNAL_IDS) {
            throw new IllegalStateException("Invalid tag: required Tag.EXTERNAL_IDS, but was Tag." + this.tag.name());
        }
        return this.externalIdsValue;
    }

    public boolean isEmails() {
        return this.tag == Tag.EMAILS;
    }

    public static UsersSelectorArg emails(List<String> value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        for (String x : value) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list is null");
        }
        return new UsersSelectorArg(Tag.EMAILS, null, null, value);
    }

    public List<String> getEmailsValue() {
        if (this.tag != Tag.EMAILS) {
            throw new IllegalStateException("Invalid tag: required Tag.EMAILS, but was Tag." + this.tag.name());
        }
        return this.emailsValue;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.tag, this.teamMemberIdsValue, this.externalIdsValue, this.emailsValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof UsersSelectorArg) {
            UsersSelectorArg other = (UsersSelectorArg)obj;
            if (this.tag != other.tag) {
                return false;
            }
            switch (this.tag) {
                case TEAM_MEMBER_IDS: {
                    return this.teamMemberIdsValue == other.teamMemberIdsValue || this.teamMemberIdsValue.equals(other.teamMemberIdsValue);
                }
                case EXTERNAL_IDS: {
                    return this.externalIdsValue == other.externalIdsValue || this.externalIdsValue.equals(other.externalIdsValue);
                }
                case EMAILS: {
                    return this.emailsValue == other.emailsValue || this.emailsValue.equals(other.emailsValue);
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends UnionJsonDeserializer<UsersSelectorArg, Tag> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(UsersSelectorArg.class, Deserializer.getTagMapping(), null, new Class[0]);
        }

        @Override
        public UsersSelectorArg deserialize(Tag _tag, JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            switch (_tag) {
                case TEAM_MEMBER_IDS: {
                    ArrayList<String> value = null;
                    Deserializer.expectField(_p, "team_member_ids");
                    Deserializer.expectArrayStart(_p);
                    value = new ArrayList<String>();
                    while (!Deserializer.isArrayEnd(_p)) {
                        String _x = null;
                        _x = Deserializer.getStringValue(_p);
                        _p.nextToken();
                        value.add(_x);
                    }
                    Deserializer.expectArrayEnd(_p);
                    _p.nextToken();
                    return UsersSelectorArg.teamMemberIds(value);
                }
                case EXTERNAL_IDS: {
                    ArrayList<String> value = null;
                    Deserializer.expectField(_p, "external_ids");
                    Deserializer.expectArrayStart(_p);
                    value = new ArrayList<String>();
                    while (!Deserializer.isArrayEnd(_p)) {
                        String _x = null;
                        _x = Deserializer.getStringValue(_p);
                        _p.nextToken();
                        value.add(_x);
                    }
                    Deserializer.expectArrayEnd(_p);
                    _p.nextToken();
                    return UsersSelectorArg.externalIds(value);
                }
                case EMAILS: {
                    ArrayList<String> value = null;
                    Deserializer.expectField(_p, "emails");
                    Deserializer.expectArrayStart(_p);
                    value = new ArrayList<String>();
                    while (!Deserializer.isArrayEnd(_p)) {
                        String _x = null;
                        _x = Deserializer.getStringValue(_p);
                        _p.nextToken();
                        value.add(_x);
                    }
                    Deserializer.expectArrayEnd(_p);
                    _p.nextToken();
                    return UsersSelectorArg.emails(value);
                }
            }
            throw new IllegalStateException("Unparsed tag: \"" + (Object)((Object)_tag) + "\"");
        }

        private static Map<String, Tag> getTagMapping() {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            values.put("team_member_ids", Tag.TEAM_MEMBER_IDS);
            values.put("external_ids", Tag.EXTERNAL_IDS);
            values.put("emails", Tag.EMAILS);
            return Collections.unmodifiableMap(values);
        }
    }

    static final class Serializer
    extends UnionJsonSerializer<UsersSelectorArg> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(UsersSelectorArg.class, new Class[0]);
        }

        @Override
        public void serialize(UsersSelectorArg value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            switch (value.tag) {
                case TEAM_MEMBER_IDS: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "team_member_ids");
                    g.writeObjectField("team_member_ids", value.teamMemberIdsValue);
                    g.writeEndObject();
                    break;
                }
                case EXTERNAL_IDS: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "external_ids");
                    g.writeObjectField("external_ids", value.externalIdsValue);
                    g.writeEndObject();
                    break;
                }
                case EMAILS: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "emails");
                    g.writeObjectField("emails", value.emailsValue);
                    g.writeEndObject();
                }
            }
        }
    }

    public static enum Tag {
        TEAM_MEMBER_IDS,
        EXTERNAL_IDS,
        EMAILS;

    }
}

