/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.users;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class Name {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String givenName;
    protected final String surname;
    protected final String familiarName;
    protected final String displayName;

    public Name(String givenName, String surname, String familiarName, String displayName) {
        if (givenName == null) {
            throw new IllegalArgumentException("Required value for 'givenName' is null");
        }
        this.givenName = givenName;
        if (surname == null) {
            throw new IllegalArgumentException("Required value for 'surname' is null");
        }
        this.surname = surname;
        if (familiarName == null) {
            throw new IllegalArgumentException("Required value for 'familiarName' is null");
        }
        this.familiarName = familiarName;
        if (displayName == null) {
            throw new IllegalArgumentException("Required value for 'displayName' is null");
        }
        this.displayName = displayName;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String getSurname() {
        return this.surname;
    }

    public String getFamiliarName() {
        return this.familiarName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.givenName, this.surname, this.familiarName, this.displayName});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            Name other = (Name)obj;
            return !(this.givenName != other.givenName && !this.givenName.equals(other.givenName) || this.surname != other.surname && !this.surname.equals(other.surname) || this.familiarName != other.familiarName && !this.familiarName.equals(other.familiarName) || this.displayName != other.displayName && !this.displayName.equals(other.displayName));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<Name> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(Name.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(Name.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<Name> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public Name deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String givenName = null;
            String surname = null;
            String familiarName = null;
            String displayName = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("given_name".equals(_field)) {
                    givenName = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("surname".equals(_field)) {
                    surname = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("familiar_name".equals(_field)) {
                    familiarName = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("display_name".equals(_field)) {
                    displayName = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (givenName == null) {
                throw new JsonParseException(_p, "Required field \"given_name\" is missing.");
            }
            if (surname == null) {
                throw new JsonParseException(_p, "Required field \"surname\" is missing.");
            }
            if (familiarName == null) {
                throw new JsonParseException(_p, "Required field \"familiar_name\" is missing.");
            }
            if (displayName == null) {
                throw new JsonParseException(_p, "Required field \"display_name\" is missing.");
            }
            return new Name(givenName, surname, familiarName, displayName);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<Name> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(Name.class);
        }

        public Serializer(boolean unwrapping) {
            super(Name.class, unwrapping);
        }

        @Override
        protected JsonSerializer<Name> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(Name value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("given_name", value.givenName);
            g.writeObjectField("surname", value.surname);
            g.writeObjectField("familiar_name", value.familiarName);
            g.writeObjectField("display_name", value.displayName);
        }
    }
}

