/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.users;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.UnionJsonDeserializer;
import com.dropbox.core.json.UnionJsonSerializer;
import com.dropbox.core.v2.users.IndividualSpaceAllocation;
import com.dropbox.core.v2.users.TeamSpaceAllocation;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public final class SpaceAllocation {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    public static final SpaceAllocation OTHER = new SpaceAllocation(Tag.OTHER, null, null);
    private final Tag tag;
    private final IndividualSpaceAllocation individualValue;
    private final TeamSpaceAllocation teamValue;

    private SpaceAllocation(Tag tag, IndividualSpaceAllocation individualValue, TeamSpaceAllocation teamValue) {
        this.tag = tag;
        this.individualValue = individualValue;
        this.teamValue = teamValue;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isIndividual() {
        return this.tag == Tag.INDIVIDUAL;
    }

    public static SpaceAllocation individual(IndividualSpaceAllocation value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new SpaceAllocation(Tag.INDIVIDUAL, value, null);
    }

    public IndividualSpaceAllocation getIndividualValue() {
        if (this.tag != Tag.INDIVIDUAL) {
            throw new IllegalStateException("Invalid tag: required Tag.INDIVIDUAL, but was Tag." + this.tag.name());
        }
        return this.individualValue;
    }

    public boolean isTeam() {
        return this.tag == Tag.TEAM;
    }

    public static SpaceAllocation team(TeamSpaceAllocation value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new SpaceAllocation(Tag.TEAM, null, value);
    }

    public TeamSpaceAllocation getTeamValue() {
        if (this.tag != Tag.TEAM) {
            throw new IllegalStateException("Invalid tag: required Tag.TEAM, but was Tag." + this.tag.name());
        }
        return this.teamValue;
    }

    public boolean isOther() {
        return this.tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.tag, this.individualValue, this.teamValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SpaceAllocation) {
            SpaceAllocation other = (SpaceAllocation)obj;
            if (this.tag != other.tag) {
                return false;
            }
            switch (this.tag) {
                case INDIVIDUAL: {
                    return this.individualValue == other.individualValue || this.individualValue.equals(other.individualValue);
                }
                case TEAM: {
                    return this.teamValue == other.teamValue || this.teamValue.equals(other.teamValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends UnionJsonDeserializer<SpaceAllocation, Tag> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(SpaceAllocation.class, Deserializer.getTagMapping(), Tag.OTHER, (Class<?>)IndividualSpaceAllocation.class, (Class<?>)TeamSpaceAllocation.class);
        }

        @Override
        public SpaceAllocation deserialize(Tag _tag, JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            switch (_tag) {
                case INDIVIDUAL: {
                    IndividualSpaceAllocation value = null;
                    value = this.readCollapsedStructValue(IndividualSpaceAllocation.class, _p, _ctx);
                    return SpaceAllocation.individual(value);
                }
                case TEAM: {
                    TeamSpaceAllocation value = null;
                    value = this.readCollapsedStructValue(TeamSpaceAllocation.class, _p, _ctx);
                    return SpaceAllocation.team(value);
                }
                case OTHER: {
                    return OTHER;
                }
            }
            throw new IllegalStateException("Unparsed tag: \"" + (Object)((Object)_tag) + "\"");
        }

        private static Map<String, Tag> getTagMapping() {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            values.put("individual", Tag.INDIVIDUAL);
            values.put("team", Tag.TEAM);
            values.put("other", Tag.OTHER);
            return Collections.unmodifiableMap(values);
        }
    }

    static final class Serializer
    extends UnionJsonSerializer<SpaceAllocation> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(SpaceAllocation.class, IndividualSpaceAllocation.class, TeamSpaceAllocation.class);
        }

        @Override
        public void serialize(SpaceAllocation value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            switch (value.tag) {
                case INDIVIDUAL: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "individual");
                    this.getUnwrappingSerializer(IndividualSpaceAllocation.class).serialize(value.individualValue, g, provider);
                    g.writeEndObject();
                    break;
                }
                case TEAM: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "team");
                    this.getUnwrappingSerializer(TeamSpaceAllocation.class).serialize(value.teamValue, g, provider);
                    g.writeEndObject();
                    break;
                }
                case OTHER: {
                    g.writeString("other");
                }
            }
        }
    }

    public static enum Tag {
        INDIVIDUAL,
        TEAM,
        OTHER;

    }
}

