/*
 * Decompiled with CFR 0.152.
 */
package com.github.boly38.mongodump.domain;

import com.github.boly38.mongodump.services.helpers.HostInfo;
import java.io.File;

public class BackupConfiguration {
    public static final String DEFAULT_BACKUP_DIRECTORY = HostInfo.isWindows() ? "C:\\TMP\\mongoBackup" : "/tmp/mongoBackup";
    String backupName = null;
    String dbName = null;
    String collectionName = null;
    String backupDirectory = DEFAULT_BACKUP_DIRECTORY;
    String backupRemoteDirectory = "/";

    private BackupConfiguration() {
    }

    public static BackupConfiguration getInstance(String dbName, String backupName) {
        BackupConfiguration conf = new BackupConfiguration();
        conf.dbName = dbName;
        conf.backupName = backupName;
        return conf;
    }

    public static BackupConfiguration getInstance(String dbName) {
        return BackupConfiguration.getInstance(dbName, dbName);
    }

    public static BackupConfiguration getInstance(String dbName, String collectionName, String backupDirectory) {
        BackupConfiguration conf = BackupConfiguration.getInstance(dbName);
        conf.collectionName = collectionName;
        if (backupDirectory != null) {
            conf.backupDirectory = backupDirectory;
        }
        return conf;
    }

    public String getAbsoluteBackupName() {
        String outDir;
        String string = outDir = this.backupDirectory != null ? this.backupDirectory : "./";
        String filename = this.backupName != null ? this.backupName : (this.dbName != null ? this.dbName : "backup");
        return String.format("%s%s%s.zip", outDir, File.separator, filename);
    }

    public String toString() {
        return String.format("BackupConfiguration[db:%s %s dir:%s file:%s.zip]", this.dbName, this.collectionName != null ? "coll:" + this.collectionName : "", this.backupDirectory, this.backupName);
    }

    public String getBackupName() {
        return this.backupName;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getBackupDirectory() {
        return this.backupDirectory;
    }

    public String getBackupRemoteDirectory() {
        return this.backupRemoteDirectory;
    }

    public void setBackupName(String backupName) {
        this.backupName = backupName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public void setBackupDirectory(String backupDirectory) {
        this.backupDirectory = backupDirectory;
    }

    public void setBackupRemoteDirectory(String backupRemoteDirectory) {
        this.backupRemoteDirectory = backupRemoteDirectory;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BackupConfiguration)) {
            return false;
        }
        BackupConfiguration other = (BackupConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$backupName = this.getBackupName();
        String other$backupName = other.getBackupName();
        if (this$backupName == null ? other$backupName != null : !this$backupName.equals(other$backupName)) {
            return false;
        }
        String this$dbName = this.getDbName();
        String other$dbName = other.getDbName();
        if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
            return false;
        }
        String this$collectionName = this.getCollectionName();
        String other$collectionName = other.getCollectionName();
        if (this$collectionName == null ? other$collectionName != null : !this$collectionName.equals(other$collectionName)) {
            return false;
        }
        String this$backupDirectory = this.getBackupDirectory();
        String other$backupDirectory = other.getBackupDirectory();
        if (this$backupDirectory == null ? other$backupDirectory != null : !this$backupDirectory.equals(other$backupDirectory)) {
            return false;
        }
        String this$backupRemoteDirectory = this.getBackupRemoteDirectory();
        String other$backupRemoteDirectory = other.getBackupRemoteDirectory();
        return !(this$backupRemoteDirectory == null ? other$backupRemoteDirectory != null : !this$backupRemoteDirectory.equals(other$backupRemoteDirectory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BackupConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $backupName = this.getBackupName();
        result = result * 59 + ($backupName == null ? 43 : $backupName.hashCode());
        String $dbName = this.getDbName();
        result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
        String $collectionName = this.getCollectionName();
        result = result * 59 + ($collectionName == null ? 43 : $collectionName.hashCode());
        String $backupDirectory = this.getBackupDirectory();
        result = result * 59 + ($backupDirectory == null ? 43 : $backupDirectory.hashCode());
        String $backupRemoteDirectory = this.getBackupRemoteDirectory();
        result = result * 59 + ($backupRemoteDirectory == null ? 43 : $backupRemoteDirectory.hashCode());
        return result;
    }
}

