/*
 * Decompiled with CFR 0.152.
 */
package com.github.boly38.mongodump.domain.hostconf;

import com.github.boly38.mongodump.domain.hostconf.IMongoServerHostConfiguration;
import com.github.boly38.mongodump.services.helpers.HostInfo;
import java.io.File;

public class MongoServerDefaultHostConfiguration
implements IMongoServerHostConfiguration {
    public static final String WIN_DEFAULT_MONGO_HOME = "C:\\Program Files\\MongoDB\\Server\\3.2";
    public static final String NIX_DEFAULT_MONGO_HOME = " /var/lib/mongodb";
    String mongoHome = HostInfo.isWindows() ? "C:\\Program Files\\MongoDB\\Server\\3.2" : " /var/lib/mongodb";
    String mongodumpBin = "mongodump";
    String mongorestoreBin = "mongorestore";
    private boolean forceMongoHome = false;

    public MongoServerDefaultHostConfiguration() {
    }

    public MongoServerDefaultHostConfiguration(String mongoHome, boolean forceMongoHome) {
        this.mongoHome = mongoHome;
        this.forceMongoHome = forceMongoHome;
    }

    private String getMongoCommandAbsolutePath(String command) {
        if (HostInfo.isWindows()) {
            return String.format("%s%s%s%s%s.exe", this.mongoHome, File.separator, "bin", File.separator, command);
        }
        if (this.forceMongoHome) {
            return String.format("%s%s%s%s%s", this.mongoHome, File.separator, "bin", File.separator, command);
        }
        return command;
    }

    @Override
    public String getMongoDumpBinAbsolutePath() {
        return this.getMongoCommandAbsolutePath(this.mongodumpBin);
    }

    @Override
    public String getMongoRestoreBinAbsolutePath() {
        return this.getMongoCommandAbsolutePath(this.mongorestoreBin);
    }

    public String getMongoHome() {
        return this.mongoHome;
    }

    public String getMongodumpBin() {
        return this.mongodumpBin;
    }

    public String getMongorestoreBin() {
        return this.mongorestoreBin;
    }

    public boolean isForceMongoHome() {
        return this.forceMongoHome;
    }

    public void setMongoHome(String mongoHome) {
        this.mongoHome = mongoHome;
    }

    public void setMongodumpBin(String mongodumpBin) {
        this.mongodumpBin = mongodumpBin;
    }

    public void setMongorestoreBin(String mongorestoreBin) {
        this.mongorestoreBin = mongorestoreBin;
    }

    public void setForceMongoHome(boolean forceMongoHome) {
        this.forceMongoHome = forceMongoHome;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MongoServerDefaultHostConfiguration)) {
            return false;
        }
        MongoServerDefaultHostConfiguration other = (MongoServerDefaultHostConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$mongoHome = this.getMongoHome();
        String other$mongoHome = other.getMongoHome();
        if (this$mongoHome == null ? other$mongoHome != null : !this$mongoHome.equals(other$mongoHome)) {
            return false;
        }
        String this$mongodumpBin = this.getMongodumpBin();
        String other$mongodumpBin = other.getMongodumpBin();
        if (this$mongodumpBin == null ? other$mongodumpBin != null : !this$mongodumpBin.equals(other$mongodumpBin)) {
            return false;
        }
        String this$mongorestoreBin = this.getMongorestoreBin();
        String other$mongorestoreBin = other.getMongorestoreBin();
        if (this$mongorestoreBin == null ? other$mongorestoreBin != null : !this$mongorestoreBin.equals(other$mongorestoreBin)) {
            return false;
        }
        return this.isForceMongoHome() == other.isForceMongoHome();
    }

    protected boolean canEqual(Object other) {
        return other instanceof MongoServerDefaultHostConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $mongoHome = this.getMongoHome();
        result = result * 59 + ($mongoHome == null ? 43 : $mongoHome.hashCode());
        String $mongodumpBin = this.getMongodumpBin();
        result = result * 59 + ($mongodumpBin == null ? 43 : $mongodumpBin.hashCode());
        String $mongorestoreBin = this.getMongorestoreBin();
        result = result * 59 + ($mongorestoreBin == null ? 43 : $mongorestoreBin.hashCode());
        result = result * 59 + (this.isForceMongoHome() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "MongoServerDefaultHostConfiguration(mongoHome=" + this.getMongoHome() + ", mongodumpBin=" + this.getMongodumpBin() + ", mongorestoreBin=" + this.getMongorestoreBin() + ", forceMongoHome=" + this.isForceMongoHome() + ")";
    }
}

