/*
 * Decompiled with CFR 0.152.
 */
package com.github.boly38.mongodump.domain.logger;

import com.github.boly38.mongodump.domain.logger.SpyLogs;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamPrinter
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(StreamPrinter.class);
    private final InputStream inputStream;
    private final String streamName;
    private final boolean isErrorStream;
    private SpyLogs spyLogs = null;

    public StreamPrinter(String streamName, InputStream inputStream, SpyLogs spy) {
        this.streamName = streamName;
        this.inputStream = inputStream;
        this.isErrorStream = false;
        this.setSpy(spy);
    }

    public StreamPrinter(String streamName, InputStream inputStream, SpyLogs spy, boolean errorStream) {
        this.streamName = streamName;
        this.inputStream = inputStream;
        this.isErrorStream = errorStream;
        this.setSpy(spy);
    }

    private BufferedReader getBufferedReader(InputStream is) {
        return new BufferedReader(new InputStreamReader(is));
    }

    @Override
    public void run() {
        BufferedReader br = this.getBufferedReader(this.inputStream);
        String ligne = "";
        try {
            ligne = br.readLine();
            while (ligne != null) {
                String logLine = String.format("%s %s", this.streamName, ligne);
                if (this.isErrorStream) {
                    log.error(logLine);
                } else {
                    log.debug(logLine);
                }
                if (this.spyLogs != null) {
                    this.spyLogs.spy(logLine);
                }
                ligne = br.readLine();
            }
        }
        catch (IOException e) {
            String excMsg = e.getMessage();
            if (excMsg != null && excMsg.contains("Stream closed")) {
                return;
            }
            e.printStackTrace();
        }
    }

    public void setSpy(SpyLogs spyLogs) {
        this.spyLogs = spyLogs;
    }
}

