/*
 * Decompiled with CFR 0.152.
 */
package com.github.boly38.mongodump.services.impl;

import com.dropbox.core.DbxException;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.ListFolderErrorException;
import com.dropbox.core.v2.files.Metadata;
import com.github.boly38.mongodump.domain.BackupConfiguration;
import com.github.boly38.mongodump.domain.BackupException;
import com.github.boly38.mongodump.domain.DeleteException;
import com.github.boly38.mongodump.domain.RestoreConfiguration;
import com.github.boly38.mongodump.domain.RestoreException;
import com.github.boly38.mongodump.domain.hostconf.IMongoServerHostConfiguration;
import com.github.boly38.mongodump.services.contract.DropboxMongoBackupService;
import com.github.boly38.mongodump.services.impl.DropboxServiceImpl;
import com.github.boly38.mongodump.services.impl.MongodumpServiceImpl;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropboxMongoBackupServiceImpl
implements DropboxMongoBackupService {
    private static final Logger log = LoggerFactory.getLogger(DropboxMongoBackupServiceImpl.class);
    private MongodumpServiceImpl mongoDumpService;
    private DropboxServiceImpl dropboxService;

    public DropboxMongoBackupServiceImpl(IMongoServerHostConfiguration hostConf) {
        MongodumpServiceImpl mongoDumpSvc;
        this.mongoDumpService = mongoDumpSvc = new MongodumpServiceImpl(hostConf);
        this.dropboxService = new DropboxServiceImpl();
    }

    @Override
    public List<Metadata> listFolder(String folderName) throws ListFolderErrorException, DbxException {
        return this.dropboxService.listFolder(folderName);
    }

    @Override
    public FileMetadata backup(BackupConfiguration backupConf) throws BackupException {
        this.dropboxService.assumeAvailable();
        String localFileBackup = null;
        try {
            FileMetadata dbFile;
            localFileBackup = this.mongoDumpService.backup(backupConf);
            String dropTarget = this.getDropboxFilename(backupConf);
            try {
                dbFile = this.dropboxService.uploadFile(localFileBackup, dropTarget);
                log.debug("backup uploaded '{}'", (Object)dbFile.getPathLower());
            }
            catch (Throwable e) {
                String exMsg = String.format("Unable to upload backup '%s' to dropbox : %s", dropTarget, e.getMessage());
                throw new BackupException(exMsg, e);
            }
            FileMetadata fileMetadata = dbFile;
            return fileMetadata;
        }
        catch (BackupException be) {
            throw be;
        }
        finally {
            if (localFileBackup != null) {
                new File(localFileBackup).delete();
            }
        }
    }

    @Override
    public String getDropboxFilename(BackupConfiguration backupConf) {
        String remoteDir = backupConf.getBackupRemoteDirectory();
        String backupName = backupConf.getBackupName();
        if (remoteDir == null) {
            throw new IllegalStateException("unable to determine dropbox filename without backup remote directory");
        }
        if (backupName == null) {
            throw new IllegalStateException("unable to determine dropbox filename without backup name");
        }
        if (!remoteDir.endsWith("/")) {
            remoteDir = String.format("%s/", remoteDir);
        }
        if (!backupName.endsWith(".zip")) {
            return String.format("%s%s.zip", remoteDir, backupName);
        }
        return String.format("%s%s", remoteDir, backupName);
    }

    @Override
    public void restore(BackupConfiguration backupConf) throws RestoreException {
        String dropBackup = this.getDropboxFilename(backupConf);
        String dbName = backupConf.getDbName();
        String collName = backupConf.getCollectionName();
        this._restore(dbName, collName, dropBackup);
    }

    private void _restore(String dbName, String collName, String backupFullName) throws RestoreException {
        this.dropboxService.assumeAvailable();
        String localFileBackup = null;
        try {
            try {
                localFileBackup = this.dropboxService.downloadFile(backupFullName);
            }
            catch (Throwable e) {
                String errMsg = String.format("Unable to download backup '%s' : %s", backupFullName, e.getMessage());
                throw new RestoreException(errMsg, e);
            }
            if (localFileBackup == null) {
                String errMsg = String.format("Backup '%s' not found", backupFullName);
                throw new RestoreException(errMsg);
            }
            RestoreConfiguration restoreConf = RestoreConfiguration.getInstance(dbName, collName, localFileBackup);
            this.mongoDumpService.restore(restoreConf);
            log.debug("restore done : {}", (Object)restoreConf);
        }
        catch (RestoreException re) {
            throw re;
        }
        finally {
            if (localFileBackup != null) {
                new File(localFileBackup).delete();
            }
        }
    }

    @Override
    public void removeBackup(BackupConfiguration backupConf) throws DeleteException {
        String dropTarget = this.getDropboxFilename(backupConf);
        try {
            log.info("removing dropbox file {}", (Object)dropTarget);
            this.dropboxService.removeFile(dropTarget);
        }
        catch (Throwable t) {
            String errMsg = String.format("Unable to remove backup '%s' : %s", backupConf, t.getMessage());
            throw new DeleteException(errMsg, t);
        }
    }

    public MongodumpServiceImpl getMongoDumpService() {
        return this.mongoDumpService;
    }

    public DropboxServiceImpl getDropboxService() {
        return this.dropboxService;
    }

    public void setMongoDumpService(MongodumpServiceImpl mongoDumpService) {
        this.mongoDumpService = mongoDumpService;
    }

    public void setDropboxService(DropboxServiceImpl dropboxService) {
        this.dropboxService = dropboxService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DropboxMongoBackupServiceImpl)) {
            return false;
        }
        DropboxMongoBackupServiceImpl other = (DropboxMongoBackupServiceImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MongodumpServiceImpl this$mongoDumpService = this.getMongoDumpService();
        MongodumpServiceImpl other$mongoDumpService = other.getMongoDumpService();
        if (this$mongoDumpService == null ? other$mongoDumpService != null : !((Object)this$mongoDumpService).equals(other$mongoDumpService)) {
            return false;
        }
        DropboxServiceImpl this$dropboxService = this.getDropboxService();
        DropboxServiceImpl other$dropboxService = other.getDropboxService();
        return !(this$dropboxService == null ? other$dropboxService != null : !this$dropboxService.equals(other$dropboxService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DropboxMongoBackupServiceImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MongodumpServiceImpl $mongoDumpService = this.getMongoDumpService();
        result = result * 59 + ($mongoDumpService == null ? 43 : ((Object)$mongoDumpService).hashCode());
        DropboxServiceImpl $dropboxService = this.getDropboxService();
        result = result * 59 + ($dropboxService == null ? 43 : $dropboxService.hashCode());
        return result;
    }

    public String toString() {
        return "DropboxMongoBackupServiceImpl(mongoDumpService=" + this.getMongoDumpService() + ", dropboxService=" + this.getDropboxService() + ")";
    }
}

