/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.data;

import org.fest.util.Objects;
import org.fest.util.Strings;

public class MapEntry {
    public final Object key;
    public final Object value;

    public static MapEntry entry(Object key, Object value) {
        return new MapEntry(key, value);
    }

    private MapEntry(Object key, Object value) {
        this.key = key;
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MapEntry other = (MapEntry)obj;
        return Objects.areEqual(this.key, other.key) && Objects.areEqual(this.value, other.value);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCodeFor(this.key);
        result = 31 * result + Objects.hashCodeFor(this.value);
        return result;
    }

    public String toString() {
        return String.format("%s[key=%s, value=%s]", this.getClass().getSimpleName(), Strings.quote(this.key), Strings.quote(this.value));
    }
}

