/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.internal;

import org.fest.assertions.core.AssertionInfo;
import org.fest.assertions.data.Offset;
import org.fest.assertions.error.ShouldBeEqualWithinOffset;
import org.fest.assertions.internal.CommonValidations;
import org.fest.assertions.internal.ComparisonStrategy;
import org.fest.assertions.internal.RealNumbers;
import org.fest.util.Objects;
import org.fest.util.VisibleForTesting;

public class Doubles
extends RealNumbers<Double> {
    private static final Doubles INSTANCE = new Doubles();

    public static Doubles instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Doubles() {
    }

    public Doubles(ComparisonStrategy comparisonStrategy) {
        super(comparisonStrategy);
    }

    @Override
    protected Double zero() {
        return 0.0;
    }

    @Override
    protected Double NaN() {
        return Double.NaN;
    }

    public void assertEqual(AssertionInfo info, Double actual, Double expected, Offset<Double> offset) {
        CommonValidations.checkOffsetIsNotNull(offset);
        CommonValidations.checkNumberIsNotNull(expected);
        Doubles.assertNotNull(info, actual);
        if (Objects.areEqual(actual, expected)) {
            return;
        }
        if (expected != null && this.isEqualTo(actual, expected, offset)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeEqualWithinOffset.shouldBeEqual(actual, expected, offset, Math.abs(expected - actual)));
    }

    @Override
    protected boolean isEqualTo(Double actual, Double expected, Offset<?> offset) {
        return Math.abs(expected - actual) <= ((Number)offset.value).doubleValue();
    }
}

