/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.taskmaster.ehcache;

import com.github.bordertech.config.Config;
import com.github.bordertech.taskmaster.cache.impl.CachingHelperProviderXmlConfig;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.cache.Cache;
import javax.inject.Singleton;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ehcache.config.CacheRuntimeConfiguration;
import org.ehcache.config.ResourcePools;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.jsr107.Eh107Configuration;

@Singleton
public class CachingHelperProviderEhCache
extends CachingHelperProviderXmlConfig {
    private static final Log LOGGER = LogFactory.getLog(CachingHelperProviderEhCache.class);
    private static final String CACHE_PREFIX = "Cache [";
    private final Map<String, Triple<String, Class, Class>> caches = new HashMap<String, Triple<String, Class, Class>>();

    public CachingHelperProviderEhCache() {
        RefreshCachePropertyChangeListener listener = new RefreshCachePropertyChangeListener();
        Config.addPropertyChangeListener((PropertyChangeListener)listener);
    }

    protected synchronized <K, V> Cache<K, V> handleGetCache(String name, Class<K> keyClass, Class<V> valueClass) {
        Cache cache = super.handleGetCache(name, keyClass, valueClass);
        if (!this.caches.containsKey(name)) {
            this.configCachePropertyValues(name, cache);
            this.caches.put(name, (Triple<String, Class, Class>)new ImmutableTriple((Object)name, keyClass, valueClass));
        }
        return cache;
    }

    private synchronized <K, V> void configCachePropertyValues(String name, Cache<K, V> cache) {
        LOGGER.info((Object)("Config cache [" + name + "] properties."));
        Eh107Configuration eh107Configuration = (Eh107Configuration)cache.getConfiguration(Eh107Configuration.class);
        CacheRuntimeConfiguration config = (CacheRuntimeConfiguration)eh107Configuration.unwrap(CacheRuntimeConfiguration.class);
        ResourcePoolsBuilder builder = ResourcePoolsBuilder.newResourcePoolsBuilder();
        boolean changed = false;
        Integer value = this.getIntegerProperty(name, "heap.size");
        if (value != null) {
            LOGGER.info((Object)(CACHE_PREFIX + name + "] heap size [" + value + "MB]."));
            builder = builder.heap((long)value.intValue(), (ResourceUnit)MemoryUnit.MB);
            changed = true;
        }
        if ((value = this.getIntegerProperty(name, "heap.entries")) != null) {
            LOGGER.info((Object)(CACHE_PREFIX + name + "] heap entries [" + value + "]."));
            builder = builder.heap((long)value.intValue(), (ResourceUnit)EntryUnit.ENTRIES);
            changed = true;
        }
        if (changed) {
            LOGGER.info((Object)(CACHE_PREFIX + name + "] config updated."));
            ResourcePools pools = builder.build();
            config.updateResourcePools(pools);
        }
    }

    private Configuration getParams() {
        return Config.getInstance();
    }

    private Integer getIntegerProperty(String name, String property) {
        return this.getParams().getInteger(this.getKey(name, property), null);
    }

    private String getKey(String name, String property) {
        return "bordertech.taskmaster.cache." + name + "." + property;
    }

    private class RefreshCachePropertyChangeListener
    implements PropertyChangeListener {
        private RefreshCachePropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LOGGER.info((Object)"Refresh cache properties.");
            for (Triple value : CachingHelperProviderEhCache.this.caches.values()) {
                String name = (String)value.getLeft();
                Cache cache = CachingHelperProviderEhCache.this.getManager().getCache(name, (Class)value.getMiddle(), (Class)value.getRight());
                if (cache == null) continue;
                CachingHelperProviderEhCache.this.configCachePropertyValues(name, cache);
            }
        }
    }
}

