/*
 * Decompiled with CFR 0.152.
 */
package httpserver.core;

import httpserver.core.ContentType;
import httpserver.core.HttpServerExchange;
import httpserver.error.InvalidInput;
import httpserver.util.Functions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public final class ResponseBuilder {
    private final Function<Object, String> toJson;
    private final HttpServerExchange exchange;
    private final Map<String, String> headers = new HashMap<String, String>();
    private int status = 500;

    public static ResponseBuilder respond(HttpServerExchange exchange) throws InvalidInput {
        return new ResponseBuilder(exchange);
    }

    public static ResponseBuilder respond(HttpServerExchange exchange, Function<Object, String> toJson) throws InvalidInput {
        return new ResponseBuilder(exchange, toJson);
    }

    private ResponseBuilder(HttpServerExchange exchange) throws InvalidInput {
        this(exchange, null);
    }

    private ResponseBuilder(HttpServerExchange exchange, Function<Object, String> toJson) throws InvalidInput {
        this.exchange = Functions.requireNotNull(exchange, "HttpServerExchange must not be null");
        this.toJson = toJson;
    }

    public ResponseBuilder status(int status) throws InvalidInput {
        this.status = Functions.requireTrue(status >= 100 && status < 999, status, "Status must be a valid HTTP status code");
        return this;
    }

    public ResponseBuilder header(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public ResponseBuilder header(String name, int value) {
        this.headers.put(name, Integer.toString(value));
        return this;
    }

    public ResponseBuilder header(String name, long value) {
        this.headers.put(name, Long.toString(value));
        return this;
    }

    public ResponseBuilder contentType(String type) {
        this.headers.put("Content-Type", type);
        return this;
    }

    public ResponseBuilder contentType(ContentType type) {
        this.headers.put("Content-Type", type.toString());
        return this;
    }

    public ResponseBuilder redirect(String url) {
        this.status = 302;
        this.headers.put("Location", url);
        return this;
    }

    private void preSend() {
        this.exchange.setStatusCode(this.status);
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            this.exchange.setResponseHeader(entry.getKey(), entry.getValue());
        }
    }

    public void send(String data) {
        this.preSend();
        this.exchange.send(data, StandardCharsets.UTF_8);
    }

    public void send(byte[] data) {
        this.preSend();
        this.exchange.send(data);
    }

    public void send(InputStream in) throws IOException {
        this.preSend();
        this.exchange.send(in.readAllBytes());
    }

    public void send(Object object) {
        if (this.toJson == null) {
            throw new IllegalStateException("Missing serializer");
        }
        this.preSend();
        this.exchange.send(this.toJson.apply(object), StandardCharsets.UTF_8);
    }

    public void send() {
        this.preSend();
    }
}

