/*
 * Decompiled with CFR 0.152.
 */
package httpserver.core;

import httpserver.core.ResponseBody;
import httpserver.core.StatusCode;
import httpserver.util.Encoding;
import httpserver.util.LengthRestrictedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class HttpServerExchange {
    private final byte[] rawRequest;
    private final String method;
    private final String uri;
    private final String protocol;
    private final List<String> headers;
    private final InputStream in;
    private final OutputStream out;
    private String path;
    private Map<String, String> queryParameters;
    private int statusCode = 200;
    private String statusMessage;
    private final Map<String, String> responseHeaders = new HashMap<String, String>();
    private ResponseBody responseBody = ResponseBody.EMPTY_BODY;
    private boolean noContentLength = false;
    private boolean responseSent = false;
    private static final byte[] RESPONSE_CONTINUE = "HTTP/1.1 100 Continue\r\n\r\n".getBytes(StandardCharsets.US_ASCII);
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH).withZone(ZoneId.of("GMT"));

    public HttpServerExchange(byte[] byArray, int n, InputStream inputStream, OutputStream outputStream) throws IOException {
        this.rawRequest = byArray;
        this.in = inputStream;
        this.out = outputStream;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(byArray, 0, n)));){
            String string;
            String string2 = bufferedReader.readLine();
            int n2 = string2.indexOf(32);
            int n3 = string2.indexOf(32, n2 + 1);
            this.method = string2.substring(0, n2);
            if (n3 != -1) {
                this.uri = string2.substring(n2 + 1, n3);
                this.protocol = string2.substring(n3 + 1);
            } else {
                this.uri = string2.substring(n2 + 1);
                this.protocol = "HTTP/0.9";
            }
            if ("HTTP/1.0".equals(this.protocol)) {
                this.responseHeaders.put("Connection", "keep-alive");
            }
            this.headers = new ArrayList<String>();
            while ((string = bufferedReader.readLine()) != null) {
                if (string.isEmpty()) {
                    break;
                }
                this.headers.add(string);
            }
        }
    }

    public byte[] getRawRequest() {
        return this.rawRequest;
    }

    public String getRequestMethod() {
        return this.method;
    }

    public String getRequestURI() {
        return this.uri;
    }

    public String getRequestProtocol() {
        return this.protocol;
    }

    public String getRequestHeader(String string) {
        String string2 = string.toLowerCase() + ": ";
        for (String string3 : this.headers) {
            if (!string3.toLowerCase().startsWith(string2)) continue;
            return string3.substring(string.length() + ": ".length());
        }
        return null;
    }

    public List<String> getRequestHeaders(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = string.toLowerCase() + ": ";
        for (String string3 : this.headers) {
            if (!string3.toLowerCase().startsWith(string2)) continue;
            arrayList.add(string3.substring(string.length() + ": ".length()));
        }
        return arrayList;
    }

    public String getRequestPath() {
        if (this.path != null) {
            return this.path;
        }
        int n = this.uri.indexOf(63);
        this.path = this.uri.substring(0, n != -1 ? n : this.uri.length());
        return this.path;
    }

    public String getQueryParameter(String string) {
        String[] stringArray;
        if (this.queryParameters != null) {
            return this.queryParameters.get(string);
        }
        this.queryParameters = new HashMap<String, String>();
        int n = this.uri.indexOf(63);
        if (n == -1) {
            return null;
        }
        for (String string2 : stringArray = this.uri.substring(n + 1).split("&")) {
            int n2 = string2.indexOf(61);
            if (n2 == -1) {
                this.queryParameters.put(string2, "");
                continue;
            }
            String string3 = Encoding.decodeUrl(string2.substring(0, n2));
            String string4 = Encoding.decodeUrl(string2.substring(n2 + 1));
            this.queryParameters.put(string3, string4);
        }
        return this.queryParameters.get(string);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int n) {
        this.statusCode = n;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String string) {
        this.statusMessage = string;
    }

    public String getResponseHeader(String string) {
        return this.responseHeaders.get(string);
    }

    public void setResponseHeader(String string, String string2) {
        this.responseHeaders.put(string, string2);
    }

    public void removeResponseHeader(String string) {
        this.responseHeaders.remove(string);
    }

    public void setNoContentLength() {
        this.noContentLength = true;
    }

    public void send(String string, Charset charset) {
        this.send(string.getBytes(charset));
    }

    public void send(byte[] byArray) {
        this.responseBody = ResponseBody.newByteArrayBody(byArray);
    }

    public void send(byte[] byArray, int n, int n2) {
        this.responseBody = ResponseBody.newByteArrayBody(byArray, n, n2);
    }

    public void send(InputStream inputStream, long l) {
        this.responseBody = ResponseBody.newInputStreamBody(inputStream, l);
    }

    public void requestBodyAccepted() throws IOException {
        String string;
        if ("HTTP/1.1".equals(this.protocol) && "100-continue".equals(string = this.getRequestHeader("Expect"))) {
            this.out.write(RESPONSE_CONTINUE);
        }
    }

    public InputStream getInputStream() {
        String string = this.getRequestHeader("Content-Length");
        if (string == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        long l = Long.parseLong(string);
        return new LengthRestrictedInputStream(this.in, l);
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void sendResponse() throws IOException {
        if (!this.responseSent) {
            if (this.shouldSendHeadResponse()) {
                PrintWriter printWriter = new PrintWriter(this.out);
                printWriter.println(this.protocol + " " + this.statusCode + " " + StatusCode.getMessageForCode(this.statusCode, this.statusMessage));
                for (Map.Entry<String, String> entry : this.responseHeaders.entrySet()) {
                    printWriter.println(entry.getKey() + ": " + entry.getValue());
                }
                if (!this.noContentLength && this.methodAllowsResponseBody() && !this.responseHeaders.containsKey("Content-Length")) {
                    printWriter.println("Content-Length: " + this.responseBody.getLength());
                }
                if (!this.responseHeaders.containsKey("Date")) {
                    printWriter.println("Date: " + DATE_FORMAT.format(Instant.now()));
                }
                printWriter.print("\r\n");
                printWriter.flush();
            }
            if (this.methodAllowsResponseBody()) {
                this.responseBody.writeTo(this.out);
            }
            this.responseSent = true;
        }
    }

    public boolean isResponseSent() {
        return this.responseSent;
    }

    public ResponseBody getResponseBody() {
        return this.responseBody;
    }

    public boolean methodAllowsResponseBody() {
        return !"HEAD".equals(this.method);
    }

    private boolean shouldSendHeadResponse() throws IOException {
        if ("HTTP/0.9".equals(this.protocol)) {
            return false;
        }
        if ("HTTP/1.0".equals(this.protocol)) {
            return true;
        }
        if ("HTTP/1.1".equals(this.protocol)) {
            return true;
        }
        throw new IOException("HTTP protocol not recognised");
    }
}

