/*
 * Decompiled with CFR 0.152.
 */
package httpserver.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public interface ResponseBody {
    public static final ResponseBody EMPTY_BODY = new ResponseBody(){

        @Override
        public long getLength() {
            return 0L;
        }

        @Override
        public void writeTo(OutputStream outputStream) {
        }
    };

    public long getLength();

    public void writeTo(OutputStream var1) throws IOException;

    public static ResponseBody newByteArrayBody(byte[] byArray) {
        return ResponseBody.newByteArrayBody(byArray, 0, byArray.length);
    }

    public static ResponseBody newByteArrayBody(final byte[] byArray, final int n, final int n2) {
        return new ResponseBody(){

            @Override
            public long getLength() {
                return byArray.length;
            }

            @Override
            public void writeTo(OutputStream outputStream) throws IOException {
                outputStream.write(byArray, n, n2);
                outputStream.flush();
            }
        };
    }

    public static ResponseBody newInputStreamBody(final InputStream inputStream, final long l) {
        return new ResponseBody(){

            @Override
            public long getLength() {
                return l;
            }

            @Override
            public void writeTo(OutputStream outputStream) throws IOException {
                int n;
                long l2 = l;
                byte[] byArray = new byte[8192];
                while ((n = inputStream.read(byArray)) != -1) {
                    int n2 = l2 < (long)n ? (int)l2 : n;
                    outputStream.write(byArray, 0, n2);
                    if ((l2 -= (long)n2) > 0L) continue;
                    break;
                }
                outputStream.flush();
            }
        };
    }
}

