/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.InternalSpatialDatatype;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerSpatialDatatype;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Geography
extends SQLServerSpatialDatatype {
    private Geography(String WellKnownText, int srid) throws SQLServerException {
        this.wkt = WellKnownText;
        this.srid = srid;
        try {
            this.parseWKTForSerialization(this, this.currentWktPos, -1, false);
        }
        catch (StringIndexOutOfBoundsException e) {
            String strError = SQLServerException.getErrString("R_illegalWKT");
            throw new SQLServerException(strError, null, 0, null);
        }
        this.serializeToWkb(false);
        this.isNull = false;
    }

    private Geography(byte[] wkb) throws SQLServerException {
        this.wkb = wkb;
        this.buffer = ByteBuffer.wrap(wkb);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.parseWkb();
        this.WKTsb = new StringBuffer();
        this.WKTsbNoZM = new StringBuffer();
        this.constructWKT(this, this.internalType, this.numberOfPoints, this.numberOfFigures, this.numberOfSegments, this.numberOfShapes);
        this.wkt = this.WKTsb.toString();
        this.wktNoZM = this.WKTsbNoZM.toString();
        this.isNull = false;
    }

    public static Geography STGeomFromText(String wkt, int srid) throws SQLServerException {
        return new Geography(wkt, srid);
    }

    public static Geography STGeomFromWKB(byte[] wkb) throws SQLServerException {
        return new Geography(wkb);
    }

    public static Geography deserialize(byte[] wkb) throws SQLServerException {
        return new Geography(wkb);
    }

    public static Geography parse(String wkt) throws SQLServerException {
        return new Geography(wkt, 4326);
    }

    public static Geography point(double x, double y, int srid) throws SQLServerException {
        return new Geography("POINT (" + x + " " + y + ")", srid);
    }

    public String STAsText() throws SQLServerException {
        if (null == this.wktNoZM) {
            this.buffer = ByteBuffer.wrap(this.wkb);
            this.buffer.order(ByteOrder.LITTLE_ENDIAN);
            this.parseWkb();
            this.WKTsb = new StringBuffer();
            this.WKTsbNoZM = new StringBuffer();
            this.constructWKT(this, this.internalType, this.numberOfPoints, this.numberOfFigures, this.numberOfSegments, this.numberOfShapes);
            this.wktNoZM = this.WKTsbNoZM.toString();
        }
        return this.wktNoZM;
    }

    public byte[] STAsBinary() {
        if (null == this.wkbNoZM) {
            this.serializeToWkb(true);
        }
        return this.wkbNoZM;
    }

    public byte[] serialize() {
        return this.wkb;
    }

    public boolean hasM() {
        return this.hasMvalues;
    }

    public boolean hasZ() {
        return this.hasZvalues;
    }

    public Double getX() {
        if (null != this.internalType && this.internalType == InternalSpatialDatatype.POINT && this.points.length == 2) {
            return this.points[0];
        }
        return null;
    }

    public Double getY() {
        if (null != this.internalType && this.internalType == InternalSpatialDatatype.POINT && this.points.length == 2) {
            return this.points[1];
        }
        return null;
    }

    public Double getM() {
        if (null != this.internalType && this.internalType == InternalSpatialDatatype.POINT && this.hasM()) {
            return this.mValues[0];
        }
        return null;
    }

    public Double getZ() {
        if (null != this.internalType && this.internalType == InternalSpatialDatatype.POINT && this.hasZ()) {
            return this.zValues[0];
        }
        return null;
    }

    public int getSrid() {
        return this.srid;
    }

    public boolean isNull() {
        return this.isNull;
    }

    public int STNumPoints() {
        return this.numberOfPoints;
    }

    public String STGeographyType() {
        if (null != this.internalType) {
            return this.internalType.getTypeName();
        }
        return null;
    }

    public String asTextZM() {
        return this.wkt;
    }

    public String toString() {
        return this.wkt;
    }

    @Override
    protected void serializeToWkb(boolean noZM) {
        int i;
        ByteBuffer buf = ByteBuffer.allocate(this.determineWkbCapacity());
        this.createSerializationProperties();
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putInt(this.srid);
        buf.put(this.version);
        buf.put(this.serializationProperties);
        if (!this.isSinglePoint && !this.isSingleLineSegment) {
            buf.putInt(this.numberOfPoints);
        }
        for (i = 0; i < this.numberOfPoints; ++i) {
            buf.putDouble(this.points[2 * i + 1]);
            buf.putDouble(this.points[2 * i]);
        }
        if (!noZM) {
            if (this.hasZvalues) {
                for (i = 0; i < this.numberOfPoints; ++i) {
                    buf.putDouble(this.zValues[i]);
                }
            }
            if (this.hasMvalues) {
                for (i = 0; i < this.numberOfPoints; ++i) {
                    buf.putDouble(this.mValues[i]);
                }
            }
        }
        if (this.isSinglePoint || this.isSingleLineSegment) {
            this.wkb = buf.array();
            return;
        }
        buf.putInt(this.numberOfFigures);
        for (i = 0; i < this.numberOfFigures; ++i) {
            buf.put(this.figures[i].getFiguresAttribute());
            buf.putInt(this.figures[i].getPointOffset());
        }
        buf.putInt(this.numberOfShapes);
        for (i = 0; i < this.numberOfShapes; ++i) {
            buf.putInt(this.shapes[i].getParentOffset());
            buf.putInt(this.shapes[i].getFigureOffset());
            buf.put(this.shapes[i].getOpenGISType());
        }
        if (this.version == 2 && null != this.segments) {
            buf.putInt(this.numberOfSegments);
            for (i = 0; i < this.numberOfSegments; ++i) {
                buf.put(this.segments[i].getSegmentType());
            }
        }
        if (noZM) {
            this.wkbNoZM = buf.array();
        } else {
            this.wkb = buf.array();
        }
    }

    @Override
    protected void parseWkb() {
        this.srid = this.buffer.getInt();
        this.version = this.buffer.get();
        this.serializationProperties = this.buffer.get();
        this.interpretSerializationPropBytes();
        this.readNumberOfPoints();
        this.readPoints();
        if (this.hasZvalues) {
            this.readZvalues();
        }
        if (this.hasMvalues) {
            this.readMvalues();
        }
        if (!this.isSinglePoint && !this.isSingleLineSegment) {
            this.readNumberOfFigures();
            this.readFigures();
            this.readNumberOfShapes();
            this.readShapes();
        }
        this.determineInternalType();
        if (this.buffer.hasRemaining() && this.version == 2 && this.internalType.getTypeCode() != 8 && this.internalType.getTypeCode() != 11) {
            this.readNumberOfSegments();
            this.readSegments();
        }
    }

    private void readPoints() {
        this.points = new double[2 * this.numberOfPoints];
        for (int i = 0; i < this.numberOfPoints; ++i) {
            this.points[2 * i + 1] = this.buffer.getDouble();
            this.points[2 * i] = this.buffer.getDouble();
        }
    }
}

