/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.modules;

import com.github.collinalpert.java2db.annotations.ForeignKeyEntity;
import com.github.collinalpert.java2db.annotations.Ignore;
import com.github.collinalpert.java2db.database.ForeignKeyReference;
import com.github.collinalpert.java2db.database.TableColumnReference;
import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.modules.AnnotationModule;
import com.github.collinalpert.java2db.modules.TableModule;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class FieldModule {
    private static final FieldModule instance = new FieldModule();
    private static final TableModule tableModule = TableModule.getInstance();
    private static final AnnotationModule annotationModule = AnnotationModule.getInstance();

    private FieldModule() {
    }

    public static FieldModule getInstance() {
        return instance;
    }

    public List<Field> getEntityFields(Class<? extends BaseEntity> instanceClass) {
        return this.getEntityFields(instanceClass, null, false);
    }

    public List<Field> getEntityFields(Class<? extends BaseEntity> instanceClass, boolean includeForeignKeys) {
        return this.getEntityFields(instanceClass, null, includeForeignKeys);
    }

    public List<Field> getEntityFields(Class<? extends BaseEntity> instanceClass, Class<?> delimiter) {
        return this.getEntityFields(instanceClass, delimiter, false);
    }

    private <E extends BaseEntity> List<Field> getEntityFields(Class<? super E> instanceClass, Class<?> delimiter, boolean includeForeignKeys) {
        LinkedList<Field> fields = new LinkedList<Field>();
        do {
            fields.addAll(Arrays.stream(instanceClass.getDeclaredFields()).filter(field -> field.getAnnotation(Ignore.class) == null && (includeForeignKeys || field.getAnnotation(ForeignKeyEntity.class) == null)).collect(Collectors.toList()));
        } while ((instanceClass = instanceClass.getSuperclass()) != delimiter);
        return fields;
    }

    public List<TableColumnReference> getAllFields(Class<? extends BaseEntity> instanceClass) {
        return this.getAllFields(instanceClass, "", 0);
    }

    private List<TableColumnReference> getAllFields(Class<? extends BaseEntity> instanceClass, String alias, int aliasCounter) {
        LinkedList<TableColumnReference> fields = new LinkedList<TableColumnReference>();
        for (Field field : this.getEntityFields(instanceClass, true)) {
            if (field.getType().isEnum()) continue;
            if (annotationModule.hasAnnotation(field, ForeignKeyEntity.class)) {
                String tempAlias = tableModule.getTableName(field.getType()).substring(0, 1) + ++aliasCounter;
                fields.add(new ForeignKeyReference(tableModule.getTableName(instanceClass), alias, field, tableModule.getTableName(field.getType()), tempAlias));
                fields.addAll(this.getAllFields(field.getType(), tempAlias, aliasCounter++));
                continue;
            }
            fields.add(new TableColumnReference(tableModule.getTableName(instanceClass), alias, field));
        }
        return fields;
    }
}

