/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.expressions.expression;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;

final class SerializedLambda
implements Serializable {
    private static final long serialVersionUID = 8025925345765570181L;
    public String functionalInterfaceClass;
    public String functionalInterfaceMethodName;
    public String implClass;
    public String implMethodName;
    public String implMethodSignature;
    public int implMethodKind;
    public Object[] capturedArgs;

    SerializedLambda() {
    }

    public static SerializedLambda extractLambda(Serializable lambda) {
        SerializedLambda serializedLambda;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream(2048){

            @Override
            public byte[] toByteArray() {
                return this.buf;
            }
        };
        try (ObjectOutputStream out = new ObjectOutputStream(byteOut);){
            out.writeObject(lambda);
        }
        byte[] data = byteOut.toByteArray();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(data)){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                Class<?> resolvedClass = super.resolveClass(desc);
                if (resolvedClass == java.lang.invoke.SerializedLambda.class) {
                    return SerializedLambda.class;
                }
                return resolvedClass;
            }
        };
        try {
            serializedLambda = (SerializedLambda)in.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        in.close();
        return serializedLambda;
    }
}

