/*
 * Decompiled with CFR 0.152.
 */
package com.github.containersolutions.operator;

import com.github.containersolutions.operator.ControllerUtils;
import com.github.containersolutions.operator.EventDispatcher;
import com.github.containersolutions.operator.OperatorException;
import com.github.containersolutions.operator.api.ResourceController;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionList;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.internal.CustomResourceOperationsImpl;
import io.fabric8.kubernetes.internal.KubernetesDeserializer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Operator {
    private final KubernetesClient k8sClient;
    private Map<ResourceController, EventDispatcher> controllers = new HashMap<ResourceController, EventDispatcher>();
    private Map<Class<? extends CustomResource>, CustomResourceOperationsImpl> customResourceClients = new HashMap<Class<? extends CustomResource>, CustomResourceOperationsImpl>();
    private static final Logger log = LoggerFactory.getLogger(Operator.class);

    public Operator(KubernetesClient k8sClient) {
        this.k8sClient = k8sClient;
    }

    public <R extends CustomResource> void registerController(ResourceController<R> controller) throws OperatorException {
        Class resClass = ControllerUtils.getCustomResourceClass(controller);
        Optional<CustomResourceDefinition> crd = this.getCustomResourceDefinitionForController(controller);
        String kind = ControllerUtils.getKind(controller);
        KubernetesDeserializer.registerCustomKind((String)ControllerUtils.getApiVersion(controller), (String)kind, resClass);
        if (!crd.isPresent()) {
            throw new OperatorException("CRD '" + resClass.getSimpleName() + "' with version '" + ControllerUtils.getVersion(controller) + "' not found");
        }
        Class list = ControllerUtils.getCustomResourceListClass(controller);
        Class doneable = ControllerUtils.getCustomResourceDonebaleClass(controller);
        MixedOperation client = this.k8sClient.customResources(crd.get(), resClass, list, doneable);
        EventDispatcher<R> eventDispatcher = new EventDispatcher<R>(controller, (CustomResourceOperationsImpl)client, client, this.k8sClient, ControllerUtils.getDefaultFinalizer(controller));
        client.watch(eventDispatcher);
        this.customResourceClients.put(resClass, (CustomResourceOperationsImpl)client);
        this.controllers.put(controller, eventDispatcher);
        log.info("Registered Controller '" + controller.getClass().getSimpleName() + "' for CRD '" + ControllerUtils.getCustomResourceClass(controller).getName() + "'");
    }

    private Optional<CustomResourceDefinition> getCustomResourceDefinitionForController(ResourceController controller) {
        CustomResourceDefinitionList crdList = (CustomResourceDefinitionList)this.k8sClient.customResourceDefinitions().list();
        return crdList.getItems().stream().filter(c -> ControllerUtils.getKind(controller).equals(c.getSpec().getNames().getKind()) && ControllerUtils.getVersion(controller).equals(c.getSpec().getVersion())).findFirst();
    }

    public Map<Class<? extends CustomResource>, CustomResourceOperationsImpl> getCustomResourceClients() {
        return this.customResourceClients;
    }

    public void stop() {
        this.k8sClient.close();
    }

    public <T extends CustomResource> CustomResourceOperationsImpl getCustomResourceClients(Class<T> customResourceClass) {
        return this.customResourceClients.get(customResourceClass);
    }
}

