/*
 * Decompiled with CFR 0.152.
 */
package com.github.containersolutions.operator;

import com.github.containersolutions.operator.Operator;
import com.github.containersolutions.operator.api.Controller;
import com.github.containersolutions.operator.api.ResourceController;
import io.fabric8.kubernetes.api.builder.Function;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.CustomResourceDoneable;
import java.util.HashMap;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtNewConstructor;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ControllerUtils {
    private static final double JAVA_VERSION = Double.parseDouble(System.getProperty("java.specification.version"));
    private static final Logger log = LoggerFactory.getLogger(Operator.class);
    private static Map<Class<? extends CustomResource>, Class<? extends CustomResourceDoneable<? extends CustomResource>>> doneableClassCache = new HashMap<Class<? extends CustomResource>, Class<? extends CustomResourceDoneable<? extends CustomResource>>>();

    ControllerUtils() {
    }

    static String getDefaultFinalizer(ResourceController controller) {
        return ControllerUtils.getAnnotation(controller).finalizerName();
    }

    static boolean getGenerationEventProcessing(ResourceController controller) {
        return ControllerUtils.getAnnotation(controller).generationAwareEventProcessing();
    }

    static <R extends CustomResource> Class<R> getCustomResourceClass(ResourceController controller) {
        return ControllerUtils.getAnnotation(controller).customResourceClass();
    }

    static String getCrdName(ResourceController controller) {
        return ControllerUtils.getAnnotation(controller).crdName();
    }

    public static <T extends CustomResource> Class<? extends CustomResourceDoneable<T>> getCustomResourceDoneableClass(ResourceController<T> controller) {
        try {
            Class<? extends CustomResource> customResourceClass = ControllerUtils.getAnnotation(controller).customResourceClass();
            String className = customResourceClass.getPackage().getName() + "." + customResourceClass.getSimpleName() + "CustomResourceDoneable";
            if (doneableClassCache.containsKey(customResourceClass)) {
                return doneableClassCache.get(customResourceClass);
            }
            ClassPool pool = ClassPool.getDefault();
            pool.appendClassPath((ClassPath)new LoaderClassPath(Thread.currentThread().getContextClassLoader()));
            CtClass superClass = pool.get(CustomResourceDoneable.class.getName());
            CtClass function = pool.get(Function.class.getName());
            CtClass customResource = pool.get(customResourceClass.getName());
            CtClass[] argTypes = new CtClass[]{customResource, function};
            CtClass customDoneable = pool.makeClass(className, superClass);
            CtConstructor ctConstructor = CtNewConstructor.make((CtClass[])argTypes, null, (String)"super($1, $2);", (CtClass)customDoneable);
            customDoneable.addConstructor(ctConstructor);
            Class doneableClass = JAVA_VERSION >= 9.0 ? customDoneable.toClass(customResourceClass) : customDoneable.toClass();
            doneableClassCache.put(customResourceClass, doneableClass);
            return doneableClass;
        }
        catch (CannotCompileException | NotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Controller getAnnotation(ResourceController controller) {
        return controller.getClass().getAnnotation(Controller.class);
    }
}

