/*
 * Decompiled with CFR 0.152.
 */
package com.github.containersolutions.operator;

import com.github.containersolutions.operator.ControllerUtils;
import com.github.containersolutions.operator.OperatorException;
import com.github.containersolutions.operator.api.ResourceController;
import com.github.containersolutions.operator.processing.EventDispatcher;
import com.github.containersolutions.operator.processing.EventScheduler;
import com.github.containersolutions.operator.processing.retry.GenericRetry;
import com.github.containersolutions.operator.processing.retry.Retry;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinition;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.CustomResourceDoneable;
import io.fabric8.kubernetes.client.CustomResourceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.internal.CustomResourceOperationsImpl;
import io.fabric8.kubernetes.internal.KubernetesDeserializer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Operator {
    private static final Logger log = LoggerFactory.getLogger(Operator.class);
    private final KubernetesClient k8sClient;
    private Map<Class<? extends CustomResource>, CustomResourceOperationsImpl> customResourceClients = new HashMap<Class<? extends CustomResource>, CustomResourceOperationsImpl>();

    public Operator(KubernetesClient k8sClient) {
        this.k8sClient = k8sClient;
    }

    public <R extends CustomResource> void registerControllerForAllNamespaces(ResourceController<R> controller) throws OperatorException {
        this.registerController(controller, true, GenericRetry.defaultLimitedExponentialRetry(), new String[0]);
    }

    public <R extends CustomResource> void registerControllerForAllNamespaces(ResourceController<R> controller, Retry retry) throws OperatorException {
        this.registerController(controller, true, retry, new String[0]);
    }

    public <R extends CustomResource> void registerController(ResourceController<R> controller, String ... targetNamespaces) throws OperatorException {
        this.registerController(controller, false, GenericRetry.defaultLimitedExponentialRetry(), targetNamespaces);
    }

    public <R extends CustomResource> void registerController(ResourceController<R> controller, Retry retry, String ... targetNamespaces) throws OperatorException {
        this.registerController(controller, false, retry, targetNamespaces);
    }

    private <R extends CustomResource> void registerController(ResourceController<R> controller, boolean watchAllNamespaces, Retry retry, String ... targetNamespaces) throws OperatorException {
        Class resClass = ControllerUtils.getCustomResourceClass(controller);
        CustomResourceDefinition crd = this.getCustomResourceDefinitionForController(controller);
        KubernetesDeserializer.registerCustomKind((String)this.getApiVersion(crd), (String)this.getKind(crd), resClass);
        MixedOperation client = this.k8sClient.customResources(crd, resClass, CustomResourceList.class, ControllerUtils.getCustomResourceDoneableClass(controller));
        EventDispatcher eventDispatcher = new EventDispatcher(controller, ControllerUtils.getDefaultFinalizer(controller), new EventDispatcher.CustomResourceReplaceFacade(client));
        EventScheduler eventScheduler = new EventScheduler(eventDispatcher, retry, ControllerUtils.getGenerationEventProcessing(controller));
        this.registerWatches(controller, client, resClass, watchAllNamespaces, targetNamespaces, eventScheduler);
    }

    private <R extends CustomResource> void registerWatches(ResourceController<R> controller, MixedOperation client, Class<R> resClass, boolean watchAllNamespaces, String[] targetNamespaces, EventScheduler eventScheduler) {
        CustomResourceOperationsImpl crClient = (CustomResourceOperationsImpl)client;
        if (watchAllNamespaces) {
            crClient.inAnyNamespace().watch((Object)eventScheduler);
        } else if (targetNamespaces.length == 0) {
            client.watch((Object)eventScheduler);
        } else {
            for (String targetNamespace : targetNamespaces) {
                crClient.inNamespace(targetNamespace).watch((Object)eventScheduler);
                log.debug("Registered controller for namespace: {}", (Object)targetNamespace);
            }
        }
        this.customResourceClients.put(resClass, (CustomResourceOperationsImpl)client);
        log.info("Registered Controller: '{}' for CRD: '{}' for namespaces: {}", new Object[]{controller.getClass().getSimpleName(), resClass, targetNamespaces.length == 0 ? "[all/client namespace]" : Arrays.toString(targetNamespaces)});
    }

    private CustomResourceDefinition getCustomResourceDefinitionForController(ResourceController controller) {
        String crdName = ControllerUtils.getCrdName(controller);
        CustomResourceDefinition customResourceDefinition = (CustomResourceDefinition)((Resource)this.k8sClient.customResourceDefinitions().withName(crdName)).get();
        if (customResourceDefinition == null) {
            throw new OperatorException("Cannot find Custom Resource Definition with name: " + crdName);
        }
        return customResourceDefinition;
    }

    public Map<Class<? extends CustomResource>, CustomResourceOperationsImpl> getCustomResourceClients() {
        return this.customResourceClients;
    }

    public <T extends CustomResource, L extends CustomResourceList<T>, D extends CustomResourceDoneable<T>> CustomResourceOperationsImpl<T, L, D> getCustomResourceClients(Class<T> customResourceClass) {
        return this.customResourceClients.get(customResourceClass);
    }

    private String getKind(CustomResourceDefinition crd) {
        return crd.getSpec().getNames().getKind();
    }

    private String getApiVersion(CustomResourceDefinition crd) {
        return crd.getSpec().getGroup() + "/" + crd.getSpec().getVersion();
    }
}

