/*
 * Decompiled with CFR 0.152.
 */
package com.github.containersolutions.operator.processing;

import com.github.containersolutions.operator.processing.CustomResourceEvent;
import com.github.containersolutions.operator.processing.EventDispatcher;
import com.github.containersolutions.operator.processing.EventScheduler;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventConsumer
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(EventConsumer.class);
    private final CustomResourceEvent event;
    private final EventDispatcher eventDispatcher;
    private final EventScheduler eventScheduler;

    EventConsumer(CustomResourceEvent event, EventDispatcher eventDispatcher, EventScheduler eventScheduler) {
        this.event = event;
        this.eventDispatcher = eventDispatcher;
        this.eventScheduler = eventScheduler;
    }

    @Override
    public void run() {
        log.debug("Processing event started: {}", (Object)this.event);
        if (this.processEvent()) {
            this.eventScheduler.eventProcessingFinishedSuccessfully(this.event);
            log.debug("Event processed successfully: {}", (Object)this.event);
        } else {
            this.eventScheduler.eventProcessingFailed(this.event);
            log.debug("Event processed failed: {}", (Object)this.event);
        }
    }

    private boolean processEvent() {
        Watcher.Action action = this.event.getAction();
        CustomResource resource = this.event.getResource();
        try {
            this.eventDispatcher.handleEvent(action, resource);
        }
        catch (RuntimeException e) {
            log.error("Processing event {} failed.", (Object)this.event, (Object)e);
            return false;
        }
        return true;
    }
}

