/*
 * Decompiled with CFR 0.152.
 */
package com.github.containersolutions.operator.processing;

import com.github.containersolutions.operator.processing.CustomResourceEvent;
import java.util.HashMap;
import java.util.Map;

public class EventStore {
    private final Map<String, CustomResourceEvent> eventsNotScheduled = new HashMap<String, CustomResourceEvent>();
    private final Map<String, CustomResourceEvent> eventsUnderProcessing = new HashMap<String, CustomResourceEvent>();
    private final Map<String, Long> lastGeneration = new HashMap<String, Long>();

    public boolean containsNotScheduledEvent(String uuid) {
        return this.eventsNotScheduled.containsKey(uuid);
    }

    public CustomResourceEvent removeEventNotScheduled(String uid) {
        return this.eventsNotScheduled.remove(uid);
    }

    public void addOrReplaceEventAsNotScheduledAndUpdateLastGeneration(CustomResourceEvent event) {
        this.eventsNotScheduled.put(event.resourceUid(), event);
        this.updateLastGeneration(event);
    }

    public boolean containsEventUnderProcessing(String uuid) {
        return this.eventsUnderProcessing.containsKey(uuid);
    }

    public void addEventUnderProcessingAndUpdateLastGeneration(CustomResourceEvent event) {
        this.eventsUnderProcessing.put(event.resourceUid(), event);
        this.updateLastGeneration(event);
    }

    public CustomResourceEvent removeEventUnderProcessing(String uid) {
        return this.eventsUnderProcessing.remove(uid);
    }

    private void updateLastGeneration(CustomResourceEvent event) {
        Long generation = event.getResource().getMetadata().getGeneration();
        Long storedGeneration = this.lastGeneration.get(event.getResource().getMetadata().getUid());
        if (storedGeneration == null || generation > storedGeneration) {
            this.lastGeneration.put(event.getResource().getMetadata().getUid(), generation);
        }
    }

    public boolean hasLargerGenerationThanLastStored(CustomResourceEvent event) {
        return this.getLastStoredGeneration(event) == null || this.getLastStoredGeneration(event) < event.getResource().getMetadata().getGeneration();
    }

    public Long getLastStoredGeneration(CustomResourceEvent event) {
        return this.lastGeneration.get(event.getResource().getMetadata().getUid());
    }

    public void removeLastGenerationForDeletedResource(String uuid) {
        this.lastGeneration.remove(uuid);
    }
}

