/*
 * Decompiled with CFR 0.152.
 */
package com.github.containersolutions.operator.processing.retry;

import com.github.containersolutions.operator.processing.retry.GenericRetry;
import com.github.containersolutions.operator.processing.retry.RetryExecution;
import java.util.Optional;

public class GenericRetryExecution
implements RetryExecution {
    private final GenericRetry genericRetry;
    private int lastAttemptIndex = 0;
    private long currentInterval;
    private long elapsedTime = 0L;

    public GenericRetryExecution(GenericRetry genericRetry) {
        this.genericRetry = genericRetry;
        this.currentInterval = genericRetry.getInitialInterval();
    }

    @Override
    public Optional<Long> nextDelay() {
        if (this.lastAttemptIndex == 0) {
            ++this.lastAttemptIndex;
            return Optional.of(0L);
        }
        if (this.genericRetry.getMaxElapsedTime() > 0L && this.lastAttemptIndex > 0) {
            this.elapsedTime += this.currentInterval;
            if (this.elapsedTime > this.genericRetry.getMaxElapsedTime()) {
                return Optional.empty();
            }
        }
        if (this.genericRetry.getMaxAttempts() > -1 && this.lastAttemptIndex >= this.genericRetry.getMaxAttempts()) {
            return Optional.empty();
        }
        if (this.lastAttemptIndex > 1) {
            this.currentInterval = (long)((double)this.currentInterval * this.genericRetry.getIntervalMultiplier());
            if (this.genericRetry.getMaxInterval() > -1L && this.currentInterval > this.genericRetry.getMaxInterval()) {
                this.currentInterval = this.genericRetry.getMaxInterval();
            }
        }
        ++this.lastAttemptIndex;
        return Optional.of(this.currentInterval);
    }
}

