/*
 * Decompiled with CFR 0.152.
 */
package com.github.containersolutions.operator.processing;

import com.github.containersolutions.operator.ControllerUtils;
import com.github.containersolutions.operator.api.DefaultContext;
import com.github.containersolutions.operator.api.ResourceController;
import com.github.containersolutions.operator.api.RetryInfo;
import com.github.containersolutions.operator.api.UpdateControl;
import com.github.containersolutions.operator.processing.CustomResourceEvent;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Replaceable;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventDispatcher {
    private static final Logger log = LoggerFactory.getLogger(EventDispatcher.class);
    private final ResourceController controller;
    private final String resourceDefaultFinalizer;
    private final CustomResourceFacade customResourceFacade;
    private final boolean generationAware;
    private final Map<String, Long> lastGenerationProcessedSuccessfully = new ConcurrentHashMap<String, Long>();

    public EventDispatcher(ResourceController controller, String defaultFinalizer, CustomResourceFacade customResourceFacade, boolean generationAware) {
        this.controller = controller;
        this.customResourceFacade = customResourceFacade;
        this.resourceDefaultFinalizer = defaultFinalizer;
        this.generationAware = generationAware;
    }

    public void handleEvent(CustomResourceEvent event) {
        Watcher.Action action = event.getAction();
        CustomResource resource = event.getResource();
        log.info("Handling {} event for resource {}", (Object)action, (Object)resource.getMetadata());
        if (Watcher.Action.ERROR == action) {
            log.error("Received error for resource: {}", (Object)resource.getMetadata().getName());
            return;
        }
        if (this.markedForDeletion(resource) && !ControllerUtils.hasDefaultFinalizer(resource, this.resourceDefaultFinalizer)) {
            log.debug("Skipping event dispatching since its marked for deletion but has no default finalizer: {}", (Object)event);
            return;
        }
        DefaultContext context = new DefaultContext(new RetryInfo(event.getRetryCount(), event.getRetryExecution().isLastExecution()));
        if (this.markedForDeletion(resource)) {
            boolean removeFinalizer = this.controller.deleteResource(resource, context);
            boolean hasDefaultFinalizer = ControllerUtils.hasDefaultFinalizer(resource, this.resourceDefaultFinalizer);
            if (removeFinalizer && hasDefaultFinalizer) {
                this.removeDefaultFinalizer(resource);
            } else {
                log.debug("Skipping finalizer remove. removeFinalizer: {}, hasDefaultFinalizer: {} ", (Object)removeFinalizer, (Object)hasDefaultFinalizer);
            }
            this.cleanup(resource);
        } else if (!ControllerUtils.hasDefaultFinalizer(resource, this.resourceDefaultFinalizer) && !this.markedForDeletion(resource)) {
            this.updateCustomResourceWithFinalizer(resource);
        } else if (!this.generationAware || this.largerGenerationThenProcessedBefore(resource)) {
            UpdateControl updateControl = this.controller.createOrUpdateResource(resource, context);
            if (updateControl.isUpdateStatusSubResource()) {
                this.customResourceFacade.updateStatus((CustomResource)updateControl.getCustomResource());
            } else if (updateControl.isUpdateCustomResource()) {
                this.updateCustomResource((CustomResource)updateControl.getCustomResource());
            }
            this.markLastGenerationProcessed(resource);
        } else {
            log.debug("Skipping processing since generation not increased. Event: {}", (Object)event);
        }
    }

    public boolean largerGenerationThenProcessedBefore(CustomResource resource) {
        Long lastGeneration = this.lastGenerationProcessedSuccessfully.get(resource.getMetadata().getUid());
        if (lastGeneration == null) {
            return true;
        }
        return resource.getMetadata().getGeneration() > lastGeneration;
    }

    private void cleanup(CustomResource resource) {
        if (this.generationAware) {
            this.lastGenerationProcessedSuccessfully.remove(resource.getMetadata().getUid());
        }
    }

    private void markLastGenerationProcessed(CustomResource resource) {
        if (this.generationAware) {
            this.lastGenerationProcessedSuccessfully.put(resource.getMetadata().getUid(), resource.getMetadata().getGeneration());
        }
    }

    private void updateCustomResourceWithFinalizer(CustomResource resource) {
        log.debug("Adding finalizer for resource: {} version: {}", (Object)resource.getMetadata().getName(), (Object)resource.getMetadata().getResourceVersion());
        this.addFinalizerIfNotPresent(resource);
        this.replace(resource);
    }

    private void updateCustomResource(CustomResource updatedResource) {
        log.debug("Updating resource: {} with version: {}", (Object)updatedResource.getMetadata().getName(), (Object)updatedResource.getMetadata().getResourceVersion());
        log.trace("Resource before update: {}", (Object)updatedResource);
        this.replace(updatedResource);
    }

    private void removeDefaultFinalizer(CustomResource resource) {
        log.debug("Removing finalizer on resource {}:", (Object)resource);
        resource.getMetadata().getFinalizers().remove(this.resourceDefaultFinalizer);
        this.customResourceFacade.replaceWithLock(resource);
    }

    private void replace(CustomResource resource) {
        log.debug("Trying to replace resource {}, version: {}", (Object)resource.getMetadata().getName(), (Object)resource.getMetadata().getResourceVersion());
        this.customResourceFacade.replaceWithLock(resource);
    }

    private void addFinalizerIfNotPresent(CustomResource resource) {
        if (!ControllerUtils.hasDefaultFinalizer(resource, this.resourceDefaultFinalizer) && !this.markedForDeletion(resource)) {
            log.info("Adding default finalizer to {}", (Object)resource.getMetadata());
            if (resource.getMetadata().getFinalizers() == null) {
                resource.getMetadata().setFinalizers(new ArrayList(1));
            }
            resource.getMetadata().getFinalizers().add(this.resourceDefaultFinalizer);
        }
    }

    private boolean markedForDeletion(CustomResource resource) {
        return resource.getMetadata().getDeletionTimestamp() != null && !resource.getMetadata().getDeletionTimestamp().isEmpty();
    }

    public static class CustomResourceFacade {
        private final MixedOperation<?, ?, ?, Resource<CustomResource, ?>> resourceOperation;

        public CustomResourceFacade(MixedOperation<?, ?, ?, Resource<CustomResource, ?>> resourceOperation) {
            this.resourceOperation = resourceOperation;
        }

        public void updateStatus(CustomResource resource) {
            log.trace("Updating status for resource: {}", (Object)resource);
            ((Resource)((NonNamespaceOperation)this.resourceOperation.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).updateStatus((Object)resource);
        }

        public CustomResource replaceWithLock(CustomResource resource) {
            return (CustomResource)((Replaceable)((Resource)((NonNamespaceOperation)this.resourceOperation.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).lockResourceVersion(resource.getMetadata().getResourceVersion())).replace((Object)resource);
        }
    }
}

