/*
 * Decompiled with CFR 0.152.
 */
package com.github.containersolutions.operator.processing.retry;

import com.github.containersolutions.operator.processing.retry.GenericRetryExecution;
import com.github.containersolutions.operator.processing.retry.Retry;

public class GenericRetry
implements Retry {
    public static final int DEFAULT_MAX_ATTEMPTS = 5;
    public static final long DEFAULT_INITIAL_INTERVAL = 2000L;
    public static final double DEFAULT_MULTIPLIER = 1.5;
    private int maxAttempts = 5;
    private long initialInterval = 2000L;
    private double intervalMultiplier = 1.5;
    private long maxInterval = -1L;

    public static GenericRetry defaultLimitedExponentialRetry() {
        return new GenericRetry();
    }

    public static GenericRetry noRetry() {
        return new GenericRetry().setMaxAttempts(1);
    }

    public static GenericRetry every10second10TimesRetry() {
        return new GenericRetry().withLinearRetry().setMaxAttempts(10).setInitialInterval(10000L);
    }

    @Override
    public GenericRetryExecution initExecution() {
        return new GenericRetryExecution(this);
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public GenericRetry setMaxAttempts(int maxRetryAttempts) {
        this.maxAttempts = maxRetryAttempts;
        return this;
    }

    public long getInitialInterval() {
        return this.initialInterval;
    }

    public GenericRetry setInitialInterval(long initialInterval) {
        this.initialInterval = initialInterval;
        return this;
    }

    public double getIntervalMultiplier() {
        return this.intervalMultiplier;
    }

    public GenericRetry setIntervalMultiplier(double intervalMultiplier) {
        this.intervalMultiplier = intervalMultiplier;
        return this;
    }

    public long getMaxInterval() {
        return this.maxInterval;
    }

    public GenericRetry setMaxInterval(long maxInterval) {
        this.maxInterval = maxInterval;
        return this;
    }

    public GenericRetry withoutMaxInterval() {
        this.maxInterval = -1L;
        return this;
    }

    public GenericRetry withoutMaxAttempts() {
        return this.setMaxAttempts(-1);
    }

    public GenericRetry withLinearRetry() {
        this.intervalMultiplier = 1.0;
        return this;
    }
}

