/*
 * Decompiled with CFR 0.152.
 */
package initialization;

import initialization.InitConverter;
import initialization.InitDefaultValues;
import initialization.InitValue;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import templateInput.ClassContainer;
import templateInput.definition.InitializedTypeDefinition;
import templateInput.definition.MethodDefinition;
import templateInput.definition.VariableDefinition;

public class InitializationService {
    private InitDefaultValues defaults = new InitDefaultValues();
    private InitConverter converter = new InitConverter();

    public void init(ClassContainer claz) {
        this.converter.reset();
        this.initVariables(claz.getFields());
        this.initMethods(claz.getMethods());
        this.initMethods(claz.getConstructors());
    }

    public void init(InitializedTypeDefinition var) {
        this.converter.reset();
        this.initialize(var);
    }

    private void initialize(InitializedTypeDefinition var) {
        if (this.defaults.containsDefaultValue(var.getType().toString())) {
            this.setDefaultInit1(var);
            this.setDefaultInit2(var);
            this.setNoInit(var);
        } else if (var.getType().toString().contains("<")) {
            this.initParameterized(var);
        } else {
            String init = var.getType() + ".builder().build()";
            var.setInit1(init);
            var.setInit2(init);
            var.setNoInit(this.defaults.getNoInitFor(var.getType().toString()));
        }
        var.setDefaultInit(this.defaults.containsEmptyInit(var.getTypeWithoutParameters()) ? this.defaults.getEmptyInit(var.getTypeWithoutParameters()).getValue() : null);
        var.setCollection(this.defaults.isCollection(var.getTypeWithoutParameters()));
    }

    private void initMethods(List<? extends MethodDefinition> methods) {
        methods.stream().forEach(this::initialize);
        methods.forEach(m -> this.initVariables(m.getParameters()));
    }

    private void initVariables(List<? extends VariableDefinition> list) {
        list.stream().forEach(this::initialize);
    }

    private void setNoInit(InitializedTypeDefinition var) {
        if (this.defaults.containsTestNoInit(var.getType().toString())) {
            InitValue value = this.defaults.getTestNoInit(var.getType().toString());
            var.setNoInit(value.getValue());
            var.addInitImports(value.getImports());
        } else {
            var.setNoInit("null");
        }
    }

    private void setDefaultInit1(InitializedTypeDefinition var) {
        if (this.defaults.containsDefaultValue(var.getType().toString())) {
            InitValue value = this.defaults.getDefaultValue1(var.getType().toString());
            var.setInit1(this.converter.convert(value.getValue()));
            var.addInitImports(value.getImports());
        }
    }

    private void setDefaultInit2(InitializedTypeDefinition var) {
        if (this.defaults.containsDefaultValue(var.getType().toString())) {
            InitValue value = this.defaults.getDefaultValue2(var.getType().toString());
            var.setInit2(this.converter.convert(value.getValue()));
            var.addInitImports(value.getImports());
        }
    }

    private void initParameterized(InitializedTypeDefinition var) {
        String mainType = var.getTypeWithoutParameters();
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        if (this.defaults.isParameterizedVariable(mainType)) {
            InitValue value = this.defaults.getParameterizedVariable(mainType);
            sb1.append(value.getValue());
            sb2.append(value.getValue());
            var.addInitImports(value.getImports());
            List<VariableDefinition> subTypes = this.getSubTypes(var);
            String init1 = subTypes.stream().map(InitializedTypeDefinition::getInit1).collect(Collectors.joining(", "));
            String init2 = subTypes.stream().map(InitializedTypeDefinition::getInit2).collect(Collectors.joining(", "));
            sb1.append(String.valueOf(init1) + ")");
            sb2.append(String.valueOf(init2) + ")");
            subTypes.stream().forEach(v -> var.addInitImports(v.getInitImports()));
        } else {
            sb1.append(String.valueOf(mainType) + ".builder().build()");
            sb2.append(String.valueOf(mainType) + ".builder().build()");
        }
        var.setInit1(sb1.toString());
        var.setInit2(sb2.toString());
        var.setNoInit(this.defaults.getNoInitFor(mainType));
    }

    private List<VariableDefinition> getSubTypes(InitializedTypeDefinition var) {
        int indexOf = var.getType().toString().indexOf("<");
        String subString = var.getType().toString().substring(indexOf + 1, var.getType().toString().length() - 1);
        List<String> subVariableTypes = this.splitSubTypes(subString);
        List<VariableDefinition> subTypes = subVariableTypes.stream().map(subType -> ((VariableDefinition.Builder)VariableDefinition.builder().withType((String)subType)).build()).collect(Collectors.toList());
        subTypes.forEach(subVar -> this.initialize((InitializedTypeDefinition)subVar));
        return subTypes;
    }

    private List<String> splitSubTypes(String type) {
        ArrayList<String> subVariableTypes = new ArrayList<String>();
        int withinBrackets = 0;
        StringBuilder currentVar = new StringBuilder();
        char[] cArray = type.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (withinBrackets > 0) {
                currentVar.append(c);
                if (c == '>' && --withinBrackets <= 0) {
                    subVariableTypes.add(currentVar.toString());
                    currentVar = new StringBuilder();
                }
            } else if (c == '<') {
                currentVar.append(c);
                ++withinBrackets;
            } else if (Character.isLetter(c) || Character.isDigit(c)) {
                currentVar.append(c);
            } else if (c == '?') {
                subVariableTypes.add("?");
            } else if (currentVar.length() > 0) {
                String current = currentVar.toString();
                if (current.equals("extends")) {
                    subVariableTypes.remove(subVariableTypes.size() - 1);
                    currentVar = new StringBuilder();
                } else {
                    subVariableTypes.add(current);
                    currentVar = new StringBuilder();
                }
            }
            ++n2;
        }
        if (currentVar.length() > 0) {
            subVariableTypes.add(currentVar.toString());
        }
        return subVariableTypes;
    }
}

