/*
 * Decompiled with CFR 0.152.
 */
package configuration;

import configuration.ClassProvider;
import configuration.DefaultAdjusters;
import configuration.JavaForgerConfiguration;

public class DefaultConfigurations {
    public static JavaForgerConfiguration forEquals() {
        return DefaultConfigurations.defaultConfig("equals.javat");
    }

    public static JavaForgerConfiguration forEqualsAndTest() {
        return DefaultConfigurations.defaultConfiguration("equals.javat", "equalsTest.javat");
    }

    public static JavaForgerConfiguration forHashCode() {
        return DefaultConfigurations.defaultConfig("hashCode.javat");
    }

    public static JavaForgerConfiguration forHashCodeAndTest() {
        return DefaultConfigurations.defaultConfiguration("hashCode.javat", "hashCodeTest.javat");
    }

    public static JavaForgerConfiguration forBuilder() {
        JavaForgerConfiguration config = DefaultConfigurations.defaultConfig("innerBuilder.javat");
        config.addParameterAdjusters(DefaultAdjusters.replaceFieldPrimitivesWithObjects());
        return config;
    }

    public static JavaForgerConfiguration forBuilderAndTest() {
        JavaForgerConfiguration config = DefaultConfigurations.defaultConfiguration("innerBuilder.javat", "innerBuilderTest.javat");
        config.addParameterAdjusters(DefaultAdjusters.replaceFieldPrimitivesWithObjects());
        return config;
    }

    public static JavaForgerConfiguration forExtendableBuilderAndTest() {
        JavaForgerConfiguration config = DefaultConfigurations.defaultConfiguration("extendableInnerBuilder.javat", "innerBuilderTest.javat");
        config.addParameterAdjusters(DefaultAdjusters.replaceFieldPrimitivesWithObjects());
        return config;
    }

    public static JavaForgerConfiguration forToString() {
        return DefaultConfigurations.defaultConfig("toString/complete.javat");
    }

    public static JavaForgerConfiguration forStateFullClassTest() {
        return DefaultConfigurations.defaultBuilder("test/generic/stateFullClassTest.javat").mergeClassProvider(ClassProvider.forMavenUnitTestFromInput()).build();
    }

    public static JavaForgerConfiguration forStatelessClassTest() {
        return DefaultConfigurations.defaultBuilder("test/generic/statelessClassTest.javat").mergeClassProvider(ClassProvider.forMavenUnitTestFromInput()).configIfFileDoesNotExist(DefaultConfigurations.emptyTestFile()).build();
    }

    protected static JavaForgerConfiguration defaultConfig(String template) {
        return DefaultConfigurations.defaultBuilder(template).build();
    }

    protected static JavaForgerConfiguration defaultConfiguration(String template, String testTemplate) {
        return DefaultConfigurations.defaultBuilder(template).childConfig(DefaultConfigurations.defaultTestConfiguration(testTemplate)).build();
    }

    private static JavaForgerConfiguration defaultTestConfiguration(String testTemplate) {
        return DefaultConfigurations.defaultBuilder(testTemplate).mergeClassProvider(ClassProvider.forMavenUnitTestFromInput()).configIfFileDoesNotExist(DefaultConfigurations.emptyTestFile()).build();
    }

    private static JavaForgerConfiguration emptyTestFile() {
        return JavaForgerConfiguration.builder().template("test/common/emptyTestClass.javat").createFileIfNotExists(true).mergeClassProvider(ClassProvider.fromParentMergeClass()).build();
    }

    protected static JavaForgerConfiguration.Builder defaultBuilder(String template) {
        return JavaForgerConfiguration.builder().template(template).mergeClassProvider(new ClassProvider()).parameterAdjusters(DefaultAdjusters.removeDepracatedFields(), DefaultAdjusters.removeStaticFields());
    }
}

