/*
 * Decompiled with CFR 0.152.
 */
package configuration;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.resolution.SymbolResolver;
import com.github.javaparser.symbolsolver.JavaSymbolSolver;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.CombinedTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.JavaParserTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.ReflectionTypeSolver;
import configuration.FreeMarkerConfiguration;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import initialization.InitializationService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.stream.Stream;
import merger.CodeSnipitMerger;
import merger.LineMerger;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reader.ClassContainerReader;

public class StaticJavaForgerConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(StaticJavaForgerConfiguration.class);
    private ClassContainerReader reader;
    private InitializationService initializer;
    private CodeSnipitMerger merger;
    private Configuration freeMarkerConfiguration = FreeMarkerConfiguration.getDefaultConfig();
    private JavaSymbolSolver symbolSolver;
    private static StaticJavaForgerConfiguration config;

    private StaticJavaForgerConfiguration() {
        this.setupSymbolSolver();
    }

    public static StaticJavaForgerConfiguration getConfig() {
        if (config == null) {
            config = new StaticJavaForgerConfiguration();
            StaticJavaForgerConfiguration.config.reader = new ClassContainerReader();
            StaticJavaForgerConfiguration.config.initializer = new InitializationService();
            StaticJavaForgerConfiguration.config.merger = new LineMerger();
        }
        return config;
    }

    public static ClassContainerReader getReader() {
        return StaticJavaForgerConfiguration.getConfig().reader;
    }

    public void setReader(ClassContainerReader classReader) {
        StaticJavaForgerConfiguration.getConfig().reader = classReader;
    }

    public static InitializationService getInitializer() {
        return StaticJavaForgerConfiguration.getConfig().initializer;
    }

    public void setInitializer(InitializationService initializer) {
        StaticJavaForgerConfiguration.getConfig().initializer = initializer;
    }

    public static void reset() {
        StaticJavaForgerConfiguration conf = StaticJavaForgerConfiguration.getConfig();
        conf.setReader(new ClassContainerReader());
        conf.setMerger(new LineMerger());
        conf.setFreeMarkerConfiguration(FreeMarkerConfiguration.getDefaultConfig());
    }

    public static CodeSnipitMerger getMerger() {
        return StaticJavaForgerConfiguration.getConfig().merger;
    }

    public void setMerger(CodeSnipitMerger merger) {
        StaticJavaForgerConfiguration.getConfig().merger = merger;
    }

    public Configuration getFreeMarkerConfiguration() {
        return this.freeMarkerConfiguration;
    }

    public void setFreeMarkerConfiguration(Configuration freeMarkerConfig) {
        this.freeMarkerConfiguration = freeMarkerConfig;
    }

    public void addTemplateLocation(String templateLocation) throws IOException {
        FileTemplateLoader loader = new FileTemplateLoader(new File(templateLocation));
        TemplateLoader original = this.getFreeMarkerConfiguration().getTemplateLoader();
        MultiTemplateLoader mtl = new MultiTemplateLoader(new TemplateLoader[]{original, loader});
        this.freeMarkerConfiguration.setTemplateLoader((TemplateLoader)mtl);
    }

    public final void setSymbolSolver(JavaSymbolSolver symbolSolver) {
        this.symbolSolver = symbolSolver;
        StaticJavaParser.getConfiguration().setSymbolResolver((SymbolResolver)symbolSolver);
    }

    public JavaSymbolSolver getSymbolSolver() {
        return this.symbolSolver;
    }

    public void setProjectPaths(String ... paths) {
        Stream.of(paths).filter(p -> !Files.exists(new File((String)p).toPath(), new LinkOption[0])).forEach(p -> LOG.error("Could not find the folder located at: " + p));
        Object[] solvers = (JavaParserTypeSolver[])Stream.of(paths).filter(p -> Files.exists(new File((String)p).toPath(), new LinkOption[0])).map(JavaParserTypeSolver::new).toArray(JavaParserTypeSolver[]::new);
        Object[] reflTypeSolver = new TypeSolver[]{new ReflectionTypeSolver()};
        CombinedTypeSolver typeSolver = new CombinedTypeSolver((TypeSolver[])ArrayUtils.addAll((Object[])reflTypeSolver, (Object[])solvers));
        JavaSymbolSolver symbolSolver = new JavaSymbolSolver((TypeSolver)typeSolver);
        this.setSymbolSolver(symbolSolver);
    }

    private final void setupSymbolSolver() {
        ReflectionTypeSolver reflTypeSolver = new ReflectionTypeSolver();
        JavaSymbolSolver symbolSolver = new JavaSymbolSolver((TypeSolver)reflTypeSolver);
        this.setSymbolSolver(symbolSolver);
    }
}

