/*
 * Decompiled with CFR 0.152.
 */
package reader;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.nodeTypes.NodeWithSimpleName;
import com.github.javaparser.ast.nodeTypes.NodeWithVariables;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reader.ImportResolver;
import templateInput.definition.VariableDefinition;

public class VariableDefintionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(VariableDefintionFactory.class);
    private ImportResolver importResolver = new ImportResolver();

    public List<VariableDefinition> create(Node node) {
        ArrayList<VariableDefinition> fields = new ArrayList<VariableDefinition>();
        if (node instanceof FieldDeclaration) {
            FieldDeclaration fd = (FieldDeclaration)node;
            VariableDefinition.Builder<?> fieldBuilder = this.createVariable((Node)fd);
            fd.getVariables().stream().map(NodeWithSimpleName::getNameAsString).map(fieldBuilder::name).map(VariableDefinition.Builder::build).forEach(fields::add);
        } else if (node instanceof VariableDeclarator) {
            fields.add(this.createSingle(node));
        } else {
            fields.add(this.createVariable(node).build());
        }
        return fields;
    }

    public VariableDefinition createSingle(Node node) {
        return this.createVariable(node).build();
    }

    private VariableDefinition.Builder<?> createVariable(Node n) {
        VariableDefinition.Builder<?> fieldBuilder = VariableDefinition.builder();
        this.addType(n, fieldBuilder);
        this.addName(n, fieldBuilder);
        this.addAnnotations(n, fieldBuilder);
        this.addOriginalInit(n, fieldBuilder);
        this.addLineAndColumn(n, fieldBuilder);
        this.addAccessModifiers(n, fieldBuilder);
        return fieldBuilder;
    }

    private void addLineAndColumn(Node n, VariableDefinition.Builder<?> fieldBuilder) {
        ((VariableDefinition.Builder)fieldBuilder.lineNumber(n.getBegin().map(p -> p.line).orElse(-1))).column(n.getBegin().map(p -> p.column).orElse(-1));
    }

    private void addType(Node n, VariableDefinition.Builder<?> fieldBuilder) {
        if (NodeWithVariables.class.isAssignableFrom(n.getClass())) {
            NodeWithVariables cast = (NodeWithVariables)n;
            List<String> imports = this.importResolver.resolveImport(cast.getElementType());
            ((VariableDefinition.Builder)fieldBuilder.typeImports(imports)).type(cast.getElementType().asString());
        }
    }

    private void addAccessModifiers(Node n, VariableDefinition.Builder<?> fieldBuilder) {
        Optional<Object> fd = Optional.empty();
        if (FieldDeclaration.class.isAssignableFrom(n.getClass())) {
            fd = Optional.of((FieldDeclaration)n);
        } else if (n instanceof VariableDeclarator) {
            Optional<Node> parentNode = n.getParentNode().filter(FieldDeclaration.class::isInstance).map(FieldDeclaration.class::cast);
            if (!fd.isPresent()) {
                LOG.warn("VariableDeclarator {} did not have a valid parent, resulting VariableDefinition will only have a name. Parent was {} of type {}", new Object[]{n, parentNode.orElse(null), parentNode.map(Object::getClass).orElse(null)});
            }
        }
        fd.ifPresent(f -> {
            VariableDefinition.Builder cfr_ignored_0 = (VariableDefinition.Builder)fieldBuilder.accessModifiers(f.getModifiers().stream().map(Node::toString).map(String::trim).collect(Collectors.toSet()));
        });
    }

    private void addAnnotations(Node n, VariableDefinition.Builder<?> fieldBuilder) {
        if (NodeWithAnnotations.class.isAssignableFrom(n.getClass())) {
            fieldBuilder.annotations(((NodeWithAnnotations)n).getAnnotations().stream().map(annotation -> annotation.getName().toString()).collect(Collectors.toSet()));
        }
    }

    private void addName(Node n, VariableDefinition.Builder<?> fieldBuilder) {
        if (NodeWithSimpleName.class.isAssignableFrom(n.getClass())) {
            fieldBuilder.name(((NodeWithSimpleName)n).getNameAsString());
        } else if (FieldDeclaration.class.isAssignableFrom(n.getClass())) {
            fieldBuilder.name(((FieldDeclaration)n).getVariable(0).getNameAsString());
        }
    }

    private void addOriginalInit(Node n, VariableDefinition.Builder<?> fieldBuilder) {
        Optional<String> originalInit = this.depthFirstSearch(n, Expression.class);
        fieldBuilder.originalInit(originalInit.orElse(null));
    }

    private Optional<String> depthFirstSearch(Node node, Class<Expression> claz) {
        if (claz.isAssignableFrom(node.getClass())) {
            return Optional.of(node.toString());
        }
        return node.getChildNodes().stream().map(n -> this.depthFirstSearch((Node)n, claz)).filter(Optional::isPresent).map(Optional::get).map(Object::toString).findFirst();
    }
}

