/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.annotation.processor;

import androidx.annotation.Keep;
import com.dailystudio.annotation.DBColumn;
import com.dailystudio.annotation.DBObject;
import com.dailystudio.annotation.processor.GenUtils;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;

public class DBObjectProcessor
extends AbstractProcessor {
    private static final String DATABASE_OBJECT_PACKAGE = "com.dailystudio.dataobject";
    private static final int DEFAULT_VERSION = 1;
    private Filer mFiler;
    private Elements mElementUtils;
    private Messager mMessager;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.mFiler = processingEnv.getFiler();
        this.mMessager = processingEnv.getMessager();
        this.mElementUtils = processingEnv.getElementUtils();
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnv) {
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(DBObject.class);
        for (Element element : elements) {
            MethodSpec methodSpec;
            if (!(element instanceof TypeElement)) continue;
            TypeElement typeElement = (TypeElement)element;
            int latestVersion = 1;
            DBObject dbObject = typeElement.getAnnotation(DBObject.class);
            if (dbObject != null) {
                latestVersion = dbObject.latestVersion();
            }
            String packageName = this.mElementUtils.getPackageOf(typeElement).getQualifiedName().toString();
            String typeName = typeElement.getSimpleName().toString();
            ClassName generatedClassName = ClassName.get((String)packageName, (String)GenUtils.getDBObjectGenClassName(typeName), (String[])new String[0]);
            this.note("gen class: %s", generatedClassName);
            MethodSpec constructorBase = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ClassName.get((String)"android.content", (String)"Context", (String[])new String[0]), "context", new Modifier[0]).addParameter(TypeName.INT, "version", new Modifier[0]).addStatement("super(context, version)", new Object[0]).addStatement("initMembers()", new Object[0]).build();
            MethodSpec constructorShortcut = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ClassName.get((String)"android.content", (String)"Context", (String[])new String[0]), "context", new Modifier[0]).addStatement("this(context, $L)", new Object[]{latestVersion}).build();
            TypeSpec.Builder classBuilder = TypeSpec.classBuilder((ClassName)generatedClassName).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass((TypeName)ClassName.get((String)DATABASE_OBJECT_PACKAGE, (String)"DatabaseObject", (String[])new String[0])).addMethod(constructorShortcut).addMethod(constructorBase).addAnnotation(Keep.class);
            this.note("dbobject: package = %s", packageName);
            this.note("dbobject: class = %s", typeName);
            List<? extends Element> subElements = element.getEnclosedElements();
            this.note("dbobject: sub-elements = %s", subElements);
            HashMap<Integer, List<FieldSpec>> fieldsMap = new HashMap<Integer, List<FieldSpec>>();
            for (Element element2 : subElements) {
                if (!(element2 instanceof VariableElement)) continue;
                VariableElement varElement = (VariableElement)element2;
                String varName = varElement.getSimpleName().toString();
                DBColumn dbColumn = varElement.getAnnotation(DBColumn.class);
                if (dbColumn == null) continue;
                TypeMirror fieldType = varElement.asType();
                String varTypeName = fieldType.toString();
                this.note("dbfield: name = %s", varName);
                this.note("dbfield: type = %s", varTypeName);
                int version = dbColumn.version();
                FieldSpec fieldSpec = this.composeColumnField(varName, varTypeName, dbColumn);
                if (fieldSpec == null) continue;
                classBuilder.addField(fieldSpec);
                List<Object> specs = fieldsMap.containsKey(version) ? (List)fieldsMap.get(version) : new ArrayList<FieldSpec>();
                specs.add(fieldSpec);
                fieldsMap.put(dbColumn.version(), specs);
            }
            List<FieldSpec> columnsFields = this.composeColumnsFields(fieldsMap);
            if (columnsFields != null) {
                for (int i = 0; i < columnsFields.size(); ++i) {
                    FieldSpec fieldSpec = columnsFields.get(i);
                    classBuilder.addField(fieldSpec);
                }
            }
            if ((methodSpec = this.composeInitMemberMethod(fieldsMap)) != null) {
                classBuilder.addMethod(methodSpec);
            }
            try {
                JavaFile.builder((String)packageName, (TypeSpec)classBuilder.build()).build().writeTo(this.mFiler);
            }
            catch (IOException e) {
                this.error("generate class for %s failed: %s", typeElement, e.toString());
            }
        }
        return true;
    }

    private MethodSpec composeInitMemberMethod(Map<Integer, List<FieldSpec>> fieldSpecs) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"initMembers").addStatement("final $T templ = getTemplate();", new Object[]{ClassName.get((String)DATABASE_OBJECT_PACKAGE, (String)"Template", (String[])new String[0])}).addModifiers(new Modifier[]{Modifier.PRIVATE});
        if (fieldSpecs == null) {
            return builder.build();
        }
        Set<Integer> keys = fieldSpecs.keySet();
        if (keys == null || keys.size() <= 0) {
            return builder.build();
        }
        LinkedList<Integer> versions = new LinkedList<Integer>(keys);
        Collections.sort(versions);
        for (int i = 0; i < versions.size(); ++i) {
            int ver = (Integer)versions.get(i);
            String fieldName = this.getVerColumnsFieldName(ver);
            if (i == 0) {
                builder.beginControlFlow("if (mVersion == $L)", new Object[]{ver});
            } else {
                builder.nextControlFlow("else if (mVersion == $L)", new Object[]{ver});
            }
            builder.addStatement("templ.addColumns($L)", new Object[]{fieldName});
        }
        builder.endControlFlow();
        return builder.build();
    }

    private List<FieldSpec> composeColumnsFields(Map<Integer, List<FieldSpec>> fieldSpecs) {
        if (fieldSpecs == null || fieldSpecs.size() <= 0) {
            return null;
        }
        ArrayList<FieldSpec> columnsFields = new ArrayList<FieldSpec>();
        Set<Integer> keys = fieldSpecs.keySet();
        LinkedList<Integer> versions = new LinkedList<Integer>(keys);
        Collections.sort(versions);
        StringBuilder columnsInitializationStatement = new StringBuilder();
        ArrayList<FieldSpec> verSpecs = new ArrayList<FieldSpec>();
        for (int i = 0; i < versions.size(); ++i) {
            int ver = (Integer)versions.get(i);
            List<FieldSpec> currVerSpecs = fieldSpecs.get(ver);
            if (currVerSpecs == null || currVerSpecs.size() <= 0) continue;
            columnsInitializationStatement.setLength(0);
            for (FieldSpec fieldSpec : currVerSpecs) {
                verSpecs.add(fieldSpec);
            }
            for (FieldSpec fieldSpec : verSpecs) {
                columnsInitializationStatement.append(fieldSpec.name);
                columnsInitializationStatement.append(",");
            }
            String fieldName = this.getVerColumnsFieldName(ver);
            FieldSpec columnsField = FieldSpec.builder((TypeName)ArrayTypeName.of((TypeName)ClassName.get((String)DATABASE_OBJECT_PACKAGE, (String)"Column", (String[])new String[0])), (String)fieldName, (Modifier[])new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).initializer("{" + columnsInitializationStatement.toString() + "}", new Object[0]).build();
            columnsFields.add(columnsField);
        }
        return columnsFields;
    }

    private FieldSpec composeColumnField(String varName, String varType, DBColumn dbColumn) {
        if (varName == null || varName.isEmpty() || varType == null || varType.isEmpty()) {
            return null;
        }
        String colName = dbColumn.name();
        if ((colName == null || colName.isEmpty()) && ((colName = varName.replaceAll("([A-Z])", "_$1").toLowerCase()).startsWith("m_") || colName.startsWith("s_"))) {
            colName = colName.substring(2);
        }
        boolean allowNull = false;
        String allowNullStr = dbColumn.allowNull();
        try {
            allowNull = Boolean.parseBoolean(allowNullStr);
        }
        catch (Exception e) {
            this.warn("parse allowNull for [%s] failed: %s, use default", varName, e.toString());
            allowNull = true;
        }
        boolean primary = false;
        String primaryStr = dbColumn.primary();
        try {
            primary = Boolean.parseBoolean(primaryStr);
        }
        catch (Exception e) {
            this.warn("parse primary for [%s] failed: %s, use default", varName, e.toString());
            primary = false;
        }
        if (primary) {
            allowNull = false;
        }
        int version = dbColumn.version();
        String fieldNameSuffix = colName.toUpperCase();
        ClassName colClassName = this.getColumnClassNameByType(varType);
        if (colClassName == null) {
            return null;
        }
        return FieldSpec.builder((TypeName)ClassName.get((String)DATABASE_OBJECT_PACKAGE, (String)"Column", (String[])new String[0]), (String)("COLUMN_" + fieldNameSuffix), (Modifier[])new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).initializer("new $T($S, $L, $L, $L)", new Object[]{colClassName, colName, allowNull, primary, version}).build();
    }

    private ClassName getColumnClassNameByType(String varType) {
        if (varType == null || varType.isEmpty()) {
            return null;
        }
        String colClassName = null;
        switch (varType.toLowerCase()) {
            case "int": 
            case "boolean": {
                colClassName = "IntegerColumn";
                break;
            }
            case "java.lang.string": {
                colClassName = "TextColumn";
                break;
            }
            case "long": {
                colClassName = "LongColumn";
                break;
            }
            case "double": {
                colClassName = "DoubleColumn";
                break;
            }
            default: {
                this.warn("[%s] is unsupported data type. ignored!", varType);
            }
        }
        if (colClassName == null) {
            return null;
        }
        return ClassName.get((String)DATABASE_OBJECT_PACKAGE, (String)colClassName, (String[])new String[0]);
    }

    private String getVerColumnsFieldName(int version) {
        return "sColumns_Ver" + version;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return new HashSet<String>(Arrays.asList(DBObject.class.getCanonicalName(), DBColumn.class.getCanonicalName()));
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    private void note(String format, Object ... args) {
        this.mMessager.printMessage(Diagnostic.Kind.NOTE, String.format(format, args));
    }

    private void error(String format, Object ... args) {
        this.mMessager.printMessage(Diagnostic.Kind.ERROR, String.format(format, args));
    }

    private void warn(String format, Object ... args) {
        this.mMessager.printMessage(Diagnostic.Kind.WARNING, String.format(format, args));
    }
}

