/*
 * Decompiled with CFR 0.152.
 */
package develop.framework.application.web.resolver;

import develop.framework.application.web.annotations.CustomRange;
import develop.framework.commons.components.DateRange;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class DateRangeArgumentResolver
implements HandlerMethodArgumentResolver {
    private String startKey;
    private String endKey;
    private String pattern;

    public DateRangeArgumentResolver() {
        this.pattern = "yyyy-MM-dd HH:mm:ss";
        this.startKey = "start_date";
        this.endKey = "end_date";
    }

    public DateRangeArgumentResolver(String pattern, String startKey, String endKey) {
        this.pattern = pattern;
        this.startKey = startKey;
        this.endKey = endKey;
    }

    public boolean supportsParameter(MethodParameter methodParameter) {
        return DateRange.class.isAssignableFrom(methodParameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest nativeWebRequest, WebDataBinderFactory binderFactory) throws Exception {
        String sk = null;
        String ek = null;
        String p = null;
        if (parameter.hasParameterAnnotation(CustomRange.class)) {
            CustomRange customDateRangeAnnotation = (CustomRange)parameter.getMethodAnnotation(CustomRange.class);
            sk = customDateRangeAnnotation.fromKey();
            ek = customDateRangeAnnotation.toKey();
            p = customDateRangeAnnotation.value();
        }
        String startDateStr = nativeWebRequest.getParameter(sk != null ? sk : this.startKey);
        String endDateStr = nativeWebRequest.getParameter(ek != null ? ek : this.endKey);
        return DateRange.parse((String)startDateStr, (String)endDateStr, (String)(p != null ? p : this.pattern));
    }

    public String getStartKey() {
        return this.startKey;
    }

    public String getEndKey() {
        return this.endKey;
    }

    public String getPattern() {
        return this.pattern;
    }
}

