/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.excel;

import com.github.developframework.excel.CellCommentInfo;
import com.github.developframework.excel.CellStyleKeyProvider;
import com.github.developframework.excel.ColumnDefinition;
import com.github.developframework.excel.ColumnInfo;
import com.github.developframework.excel.styles.CellStyleManager;
import com.github.developframework.excel.utils.ValueConvertUtils;
import com.github.developframework.expression.ExpressionUtils;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.function.BiFunction;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public abstract class AbstractColumnDefinition<ENTITY, FIELD>
implements ColumnDefinition<ENTITY> {
    protected ColumnInfo columnInfo;
    protected BiFunction<ENTITY, FIELD, Object> writeConvertFunction;
    protected BiFunction<ENTITY, Object, FIELD> readConvertFunction;
    protected CellStyleKeyProvider<ENTITY> cellStyleKeyProvider;
    protected CellCommentInfo cellCommentInfo;

    public AbstractColumnDefinition(String field, String header) {
        this.columnInfo = new ColumnInfo(field, header == null ? field : header);
    }

    @Override
    public Object writeIntoCell(Workbook workbook, Sheet sheet, Cell cell, ENTITY entity, int index) {
        FIELD fieldValue = this.getEntityValue(entity);
        FIELD convertValue = this.writeConvertFunction == null ? fieldValue : this.writeConvertFunction.apply(entity, fieldValue);
        this.setCellValue(cell, convertValue);
        if (this.cellCommentInfo != null) {
            Object c = ExpressionUtils.getValue(entity, (String)this.cellCommentInfo.getCommentField());
            Object a = ExpressionUtils.getValue(entity, (String)this.cellCommentInfo.getAuthorField());
            if (c != null && a != null) {
                Drawing drawing = sheet.createDrawingPatriarch();
                ClientAnchor anchor = this.cellCommentInfo.getAnchorFunction().apply(drawing, cell);
                anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_DONT_RESIZE);
                Comment comment = drawing.createCellComment(anchor);
                comment.setString((RichTextString)new XSSFRichTextString(c.toString()));
                comment.setAuthor(a.toString());
                cell.setCellComment(comment);
            }
        }
        return convertValue;
    }

    @Override
    public void readOutCell(Workbook workbook, Cell cell, ENTITY entity) {
        Object convertValue;
        Field field = FieldUtils.getDeclaredField(entity.getClass(), (String)this.columnInfo.field, (boolean)true);
        Object cellValue = this.getCellValue(cell, field.getType());
        Object object = convertValue = this.readConvertFunction == null ? cellValue : this.readConvertFunction.apply(entity, cellValue);
        if (convertValue != null) {
            this.setEntityValue(entity, convertValue);
        }
    }

    protected void setCellValue(Cell cell, Object convertValue) {
        if (convertValue == null) {
            cell.setBlank();
        } else {
            Class<?> clazz = convertValue.getClass();
            if (clazz == String.class) {
                cell.setCellValue((String)convertValue);
            } else if (clazz == Integer.class || clazz == Integer.TYPE) {
                cell.setCellValue(((Integer)convertValue).doubleValue());
            } else if (clazz == Float.class || clazz == Float.TYPE) {
                cell.setCellValue(((Float)convertValue).doubleValue());
            } else if (clazz == Double.class || clazz == Double.TYPE) {
                cell.setCellValue(((Double)convertValue).doubleValue());
            } else if (clazz == BigDecimal.class) {
                cell.setCellValue(((BigDecimal)convertValue).doubleValue());
            } else if (clazz == Boolean.class || clazz == Boolean.TYPE) {
                cell.setCellValue(((Boolean)convertValue).booleanValue());
            } else if (clazz == LocalDateTime.class) {
                cell.setCellValue(Date.from(((LocalDateTime)convertValue).atZone(ZoneId.systemDefault()).toInstant()));
            } else if (clazz == ZonedDateTime.class) {
                cell.setCellValue(Date.from(((ZonedDateTime)convertValue).toInstant()));
            } else if (clazz == LocalDate.class || clazz == LocalTime.class) {
                cell.setCellValue(convertValue.toString());
            } else if (clazz == Date.class) {
                cell.setCellValue((Date)convertValue);
            } else {
                cell.setCellValue(convertValue.toString());
            }
        }
    }

    public Object getCellValue(Cell cell, Class<?> fieldClass) {
        Object value;
        switch (cell.getCellType()) {
            case STRING: {
                value = ValueConvertUtils.stringConvert(cell.getRichStringCellValue().getString().trim(), fieldClass);
                break;
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    value = ValueConvertUtils.dateConvert(cell.getDateCellValue(), fieldClass);
                    break;
                }
                cell.setCellType(CellType.STRING);
                value = ValueConvertUtils.doubleConvert(cell.getStringCellValue().trim(), fieldClass);
                break;
            }
            case BOOLEAN: {
                value = ValueConvertUtils.booleanConvert(cell.getBooleanCellValue(), fieldClass);
                break;
            }
            default: {
                value = null;
            }
        }
        return value;
    }

    protected void setEntityValue(ENTITY entity, Object value) {
        FieldUtils.writeDeclaredField(entity, (String)this.columnInfo.field, (Object)value, (boolean)true);
    }

    protected FIELD getEntityValue(ENTITY entity) {
        return (FIELD)(this.columnInfo.field == null ? null : ExpressionUtils.getValue(entity, (String)this.columnInfo.field));
    }

    public final AbstractColumnDefinition<ENTITY, FIELD> columnWidth(int columnWidth) {
        this.columnInfo.columnWidth = columnWidth;
        return this;
    }

    @Override
    public void configureCellStyle(Cell cell, CellStyleManager cellStyleManager, ENTITY entity, Object value) {
        String cellStyleKey = null;
        if (this.cellStyleKeyProvider != null) {
            cellStyleKey = this.cellStyleKeyProvider.provideCellStyleKey(cell, entity, value);
        }
        if (StringUtils.isEmpty(cellStyleKey)) {
            cellStyleKey = this.determineCellStyleKey(cell, value);
        }
        cell.setCellStyle(cellStyleManager.getCellStyle(cellStyleKey));
    }

    protected String determineCellStyleKey(Cell cell, Object value) {
        if (cell.getCellType() == CellType.NUMERIC) {
            Class<?> valueClass = value.getClass();
            if (valueClass == LocalDateTime.class || valueClass == ZonedDateTime.class || valueClass == Date.class) {
                return "dataFormat {format: 'yyyy-mm-dd hh:mm:ss'}";
            }
            if (Number.class.isAssignableFrom(valueClass)) {
                return "align {horizontal: RIGHT}";
            }
        }
        return "";
    }

    public AbstractColumnDefinition<ENTITY, FIELD> writeConvert(BiFunction<ENTITY, FIELD, Object> writeConvertFunction) {
        this.writeConvertFunction = writeConvertFunction;
        return this;
    }

    public AbstractColumnDefinition<ENTITY, FIELD> readConvert(BiFunction<ENTITY, Object, FIELD> readConvertFunction) {
        this.readConvertFunction = readConvertFunction;
        return this;
    }

    public AbstractColumnDefinition<ENTITY, FIELD> cellStyleKey(CellStyleKeyProvider<ENTITY> cellStyleKeyProvider) {
        this.cellStyleKeyProvider = cellStyleKeyProvider;
        return this;
    }

    public AbstractColumnDefinition<ENTITY, FIELD> comment(String author, String commentField, BiFunction<Drawing, Cell, ClientAnchor> anchorFunction) {
        this.cellCommentInfo = new CellCommentInfo(author, commentField, anchorFunction);
        return this;
    }

    @Override
    public ColumnInfo getColumnInfo() {
        return this.columnInfo;
    }
}

