/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.excel;

import com.github.developframework.excel.ExcelReader;
import com.github.developframework.excel.ExcelType;
import com.github.developframework.excel.ExcelWriter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public final class ExcelIO {
    public static ExcelWriter writer(ExcelType excelType) {
        HSSFWorkbook workbook;
        switch (excelType) {
            case XLS: {
                workbook = new HSSFWorkbook();
                break;
            }
            case XLSX: {
                workbook = new SXSSFWorkbook();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return new ExcelWriter((Workbook)workbook);
    }

    public static ExcelReader reader(ExcelType excelType, InputStream inputStream) throws IOException {
        HSSFWorkbook workbook;
        switch (excelType) {
            case XLS: {
                workbook = new HSSFWorkbook(inputStream);
                break;
            }
            case XLSX: {
                workbook = new XSSFWorkbook(inputStream);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return new ExcelReader((Workbook)workbook);
    }

    public static ExcelReader reader(String filename) throws IOException {
        try (FileInputStream in = new FileInputStream(filename);){
            ExcelReader excelReader = ExcelIO.reader(ExcelType.parse(filename), in);
            return excelReader;
        }
    }

    public static ExcelReader readerWithPassword(InputStream inputStream, String password) throws IOException {
        return new ExcelReader(WorkbookFactory.create((InputStream)inputStream, (String)password));
    }

    public static ExcelReader readerWithPassword(String filename, String password) {
        try {
            return ExcelIO.readerWithPassword(new FileInputStream(filename), password);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

