/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.excel;

import com.github.developframework.excel.ColumnDefinition;
import com.github.developframework.excel.ExcelProcessor;
import com.github.developframework.excel.TableDefinition;
import com.github.developframework.excel.TableInfo;
import com.github.developframework.excel.TableLocation;
import com.github.developframework.excel.column.BlankColumnDefinition;
import com.github.developframework.excel.column.ColumnDefinitionBuilder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelReader
extends ExcelProcessor {
    private static final Logger log = LoggerFactory.getLogger(ExcelReader.class);

    protected ExcelReader(Workbook workbook) {
        super(workbook);
    }

    public <ENTITY> List<ENTITY> read(Class<ENTITY> entityClass, TableDefinition<ENTITY> tableDefinition) {
        return this.read(entityClass, Integer.MAX_VALUE, tableDefinition);
    }

    public <ENTITY> List<ENTITY> read(Class<ENTITY> entityClass, Integer readSize, TableDefinition<ENTITY> tableDefinition) {
        TableInfo tableInfo = tableDefinition.tableInfo();
        Sheet sheet = this.getSheet(this.workbook, tableInfo);
        TableLocation tableLocation = tableInfo.tableLocation;
        int totalSize = sheet.getLastRowNum() + 1 - tableLocation.getRow() - (tableInfo.hasTitle ? 1 : 0) - (tableInfo.hasColumnHeader ? 1 : 0);
        int startColumnIndex = tableLocation.getColumn();
        int rowIndex = tableLocation.getRow() + (tableInfo.hasTitle ? 1 : 0) + (tableInfo.hasColumnHeader ? 1 : 0);
        ColumnDefinition<ENTITY>[] columnDefinitions = tableDefinition.columnDefinitions(this.workbook, new ColumnDefinitionBuilder(this.workbook));
        int size = Math.min(readSize, totalSize);
        LinkedList<ENTITY> list = new LinkedList<ENTITY>();
        for (int i = 0; i < size; ++i) {
            Row row = sheet.getRow(rowIndex + i);
            ColumnDefinition<ENTITY> columnDefinition = null;
            try {
                ENTITY entity = entityClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                for (int j = 0; j < columnDefinitions.length; ++j) {
                    Cell cell;
                    columnDefinition = columnDefinitions[j];
                    if (columnDefinition == null || columnDefinition instanceof BlankColumnDefinition || (cell = row.getCell(startColumnIndex + j)) == null) continue;
                    columnDefinition.readOutCell(this.workbook, cell, entity);
                }
                tableDefinition.each(entity);
                list.add(entity);
                continue;
            }
            catch (Exception e) {
                assert (columnDefinition != null);
                log.error("row {} column {}", (Object)row.getRowNum(), (Object)columnDefinition.getColumnInfo().field);
                throw new RuntimeException(e);
            }
        }
        return new ArrayList(list);
    }

    private Sheet getSheet(Workbook workbook, TableInfo tableInfo) {
        if (tableInfo.sheetName != null) {
            return workbook.getSheet(tableInfo.sheetName);
        }
        return workbook.getSheetAt(tableInfo.sheet);
    }
}

