/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.excel;

public enum ExcelType {
    XLS(".xls"),
    XLSX(".xlsx");

    private String extensionName;

    private ExcelType(String extensionName) {
        this.extensionName = extensionName;
    }

    public static ExcelType parse(String filename) {
        if (filename.endsWith(XLSX.getExtensionName())) {
            return XLSX;
        }
        if (filename.endsWith(XLS.getExtensionName())) {
            return XLS;
        }
        throw new IllegalArgumentException();
    }

    public String getExtensionName() {
        return this.extensionName;
    }
}

