/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.excel;

import com.github.developframework.excel.ColumnDefinition;
import com.github.developframework.excel.ColumnInfo;
import com.github.developframework.excel.ExcelProcessor;
import com.github.developframework.excel.PreparedTableDataHandler;
import com.github.developframework.excel.SheetExtraHandler;
import com.github.developframework.excel.TableDefinition;
import com.github.developframework.excel.TableInfo;
import com.github.developframework.excel.column.ColumnDefinitionBuilder;
import com.github.developframework.excel.styles.CellStyleManager;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFSheet;

public class ExcelWriter
extends ExcelProcessor {
    protected ExcelWriter(Workbook workbook) {
        super(workbook);
    }

    public <ENTITY> ExcelWriter load(List<ENTITY> data, TableDefinition<ENTITY> tableDefinition) {
        this.writeInternal(tableDefinition, data);
        return this;
    }

    public <ENTITY> ExcelWriter load(ENTITY[] data, TableDefinition<ENTITY> tableDefinition) {
        this.writeInternal(tableDefinition, Arrays.asList(data));
        return this;
    }

    public void write(OutputStream outputStream) {
        try {
            this.workbook.write(outputStream);
            this.workbook.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public File writeToFile(String filename) {
        File file;
        File file2 = new File(filename);
        FileOutputStream os = new FileOutputStream(file2);
        try {
            this.write(os);
            file = file2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((OutputStream)os).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ((OutputStream)os).close();
        return file;
    }

    public byte[] writeToByteArray() {
        byte[] byArray;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            this.write(os);
            byArray = os.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        os.close();
        return byArray;
    }

    private <ENTITY> void writeInternal(TableDefinition<ENTITY> tableDefinition, List<ENTITY> list) {
        PreparedTableDataHandler<?> preparedTableDataHandler = tableDefinition.preparedTableDataHandler();
        if (preparedTableDataHandler != null) {
            preparedTableDataHandler.handle(list);
        }
        TableInfo tableInfo = tableDefinition.tableInfo();
        Sheet sheet = this.createSheet(tableInfo);
        int startColumnIndex = tableInfo.tableLocation.getColumn();
        int rowIndex = tableInfo.tableLocation.getRow();
        CellStyleManager cellStyleManager = new CellStyleManager(this.workbook, tableDefinition);
        ColumnDefinition<ENTITY>[] columnDefinitions = tableDefinition.columnDefinitions(this.workbook, new ColumnDefinitionBuilder(this.workbook));
        if (tableInfo.hasTitle && tableInfo.title != null) {
            tableDefinition.createTableTitle(sheet, cellStyleManager, rowIndex++, startColumnIndex, tableInfo.title, columnDefinitions.length);
        }
        if (tableInfo.hasColumnHeader) {
            rowIndex = tableDefinition.createTableColumnHeader(sheet, cellStyleManager, rowIndex, startColumnIndex, columnDefinitions);
        }
        tableDefinition.createTableBody(this.workbook, sheet, cellStyleManager, rowIndex, startColumnIndex, columnDefinitions, list);
        SheetExtraHandler<?> sheetExtraHandler = tableDefinition.sheetExtraHandler();
        if (sheetExtraHandler != null) {
            sheetExtraHandler.handle(this.workbook, sheet, cellStyleManager, rowIndex, rowIndex + list.size(), list);
        }
        this.configureColumnWidth(columnDefinitions, sheet, startColumnIndex);
    }

    private Sheet createSheet(TableInfo tableInfo) {
        Sheet sheet = tableInfo.sheetName == null ? this.workbook.createSheet() : this.workbook.createSheet(tableInfo.sheetName);
        if (sheet instanceof SXSSFSheet) {
            ((SXSSFSheet)sheet).setRandomAccessWindowSize(-1);
            ((SXSSFSheet)sheet).trackAllColumnsForAutoSizing();
        }
        return sheet;
    }

    private <ENTITY> void configureColumnWidth(ColumnDefinition<ENTITY>[] columnDefinitions, Sheet sheet, int startColumnIndex) {
        int maxWidth = 65280;
        for (int i = 0; i < columnDefinitions.length; ++i) {
            int col = startColumnIndex + i;
            ColumnInfo columnInfo = columnDefinitions[i].getColumnInfo();
            if (columnInfo == null) continue;
            if (columnInfo.columnWidth == null) {
                sheet.autoSizeColumn(col);
                sheet.setColumnWidth(col, Math.min(65280, sheet.getColumnWidth(i)));
                continue;
            }
            sheet.setColumnWidth(col, Math.min(65280, columnInfo.columnWidth * 256));
        }
    }
}

