/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.excel;

import com.github.developframework.excel.ColumnDefinition;
import com.github.developframework.excel.ColumnInfo;
import com.github.developframework.excel.PreparedTableDataHandler;
import com.github.developframework.excel.SheetExtraHandler;
import com.github.developframework.excel.TableInfo;
import com.github.developframework.excel.column.ColumnDefinitionBuilder;
import com.github.developframework.excel.styles.CellStyleManager;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;

public interface TableDefinition<ENTITY> {
    default public TableInfo tableInfo() {
        return new TableInfo();
    }

    default public PreparedTableDataHandler<?> preparedTableDataHandler() {
        return null;
    }

    public ColumnDefinition<ENTITY>[] columnDefinitions(Workbook var1, ColumnDefinitionBuilder<ENTITY> var2);

    default public void each(ENTITY entity) {
    }

    default public Map<String, CellStyle> customCellStyles(Workbook workbook) {
        return Collections.emptyMap();
    }

    default public BiConsumer<Workbook, CellStyle> globalCellStylesHandle() {
        return null;
    }

    default public SheetExtraHandler<?> sheetExtraHandler() {
        return null;
    }

    default public void createTableTitle(Sheet sheet, CellStyleManager cellStyleManager, int rowIndex, int startColumnIndex, String title, int columnSize) {
        if (title != null && !title.isBlank()) {
            Row titleRow = sheet.createRow(rowIndex);
            CellStyle cellStyle = cellStyleManager.getCellStyle("font {size: 16; bold}");
            for (int i = startColumnIndex; i < startColumnIndex + columnSize; ++i) {
                titleRow.createCell(i).setCellStyle(cellStyle);
            }
            if (columnSize > 1) {
                sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, startColumnIndex, startColumnIndex + columnSize - 1));
            }
            titleRow.getCell(startColumnIndex).setCellValue(title);
        }
    }

    default public int createTableColumnHeader(Sheet sheet, CellStyleManager cellStyleManager, int rowIndex, int startColumnIndex, ColumnDefinition<ENTITY>[] columnDefinitions) {
        Row headerRow = sheet.createRow(rowIndex);
        CellStyle headerCellStyle = cellStyleManager.getCellStyle("font {bold}");
        for (int i = 0; i < columnDefinitions.length; ++i) {
            Cell headerCell = headerRow.createCell(startColumnIndex + i);
            ColumnDefinition<ENTITY> columnDefinition = columnDefinitions[i];
            if (columnDefinition == null || columnDefinition.getColumnInfo() == null) continue;
            ColumnInfo columnInfo = columnDefinition.getColumnInfo();
            headerCell.setCellStyle(headerCellStyle);
            headerCell.setCellValue(columnInfo.header);
        }
        return rowIndex + 1;
    }

    default public void createTableBody(Workbook workbook, Sheet sheet, CellStyleManager cellStyleManager, int rowIndex, int startColumnIndex, ColumnDefinition<ENTITY>[] columnDefinitions, List<ENTITY> list) {
        for (int i = 0; i < list.size(); ++i) {
            ENTITY entity = list.get(i);
            this.each(entity);
            Row row = sheet.createRow(rowIndex + i);
            for (int j = 0; j < columnDefinitions.length; ++j) {
                ColumnDefinition<ENTITY> columnDefinition = columnDefinitions[j];
                Cell cell = row.createCell(startColumnIndex + j);
                Object convertValue = columnDefinition.writeIntoCell(workbook, sheet, cell, entity, i);
                columnDefinition.configureCellStyle(cell, cellStyleManager, entity, convertValue);
            }
        }
    }
}

