/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.excel.column;

import com.github.developframework.excel.ColumnDefinition;
import com.github.developframework.excel.column.BlankColumnDefinition;
import com.github.developframework.excel.column.FormulaColumnDefinition;
import com.github.developframework.excel.column.GeneralColumnDefinition;
import com.github.developframework.excel.column.LiteralColumnDefinition;
import java.util.function.Function;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Workbook;

public class ColumnDefinitionBuilder<ENTITY> {
    private final Workbook workbook;
    private FormulaEvaluator formulaEvaluator;

    public ColumnDefinitionBuilder(Workbook workbook) {
        this.workbook = workbook;
    }

    @SafeVarargs
    public final ColumnDefinition<ENTITY>[] columnDefinitions(ColumnDefinition<ENTITY> ... columnDefinitions) {
        return columnDefinitions;
    }

    public BlankColumnDefinition<ENTITY> blank(String header) {
        return new BlankColumnDefinition(header);
    }

    public BlankColumnDefinition<ENTITY> blank() {
        return this.blank(null);
    }

    public <FIELD> GeneralColumnDefinition<ENTITY, FIELD> column(String field, String header) {
        return new GeneralColumnDefinition(field, header);
    }

    public <FIELD> GeneralColumnDefinition<ENTITY, FIELD> column(String field) {
        return this.column(field, null);
    }

    public LiteralColumnDefinition<ENTITY> literal(String field, String header) {
        return new LiteralColumnDefinition(field, header);
    }

    public LiteralColumnDefinition<ENTITY> literal(String field) {
        return this.literal(field, null);
    }

    public <FIELD> FormulaColumnDefinition<ENTITY, FIELD> formula(Class<?> fieldClass, String field, String header, String formula) {
        if (this.formulaEvaluator == null) {
            this.formulaEvaluator = this.workbook.getCreationHelper().createFormulaEvaluator();
        }
        return new FormulaColumnDefinition(this.formulaEvaluator, field, header, formula, null, fieldClass);
    }

    public <FIELD> FormulaColumnDefinition<ENTITY, FIELD> formula(Class<?> fieldClass, String header, String formula) {
        return this.formula(fieldClass, null, header, formula);
    }

    public <FIELD> FormulaColumnDefinition<ENTITY, FIELD> formula(Class<?> fieldClass, String field, String header, Function<Cell, String> formulaFunction) {
        if (this.formulaEvaluator == null) {
            this.formulaEvaluator = this.workbook.getCreationHelper().createFormulaEvaluator();
        }
        return new FormulaColumnDefinition(this.formulaEvaluator, field, header, null, formulaFunction, fieldClass);
    }

    public <FIELD> FormulaColumnDefinition<ENTITY, FIELD> formula(Class<?> fieldClass, String header, Function<Cell, String> formulaFunction) {
        return this.formula(fieldClass, null, header, formulaFunction);
    }

    public <FIELD> FormulaColumnDefinition<ENTITY, FIELD> formula(Class<?> fieldClass, String field) {
        return this.formula(fieldClass, field, null, (String)null);
    }
}

